/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.AbstractSolrReferenceResolver;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="wiki")
@Singleton
public class WikiSolrReferenceResolver
extends AbstractSolrReferenceResolver {
    @Inject
    @Named(value="space")
    private Provider<SolrReferenceResolver> spaceResolverProvider;
    @Inject
    private QueryManager queryManager;

    public List<EntityReference> getReferences(EntityReference wikiReference) throws SolrIndexerException {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        List spaces = null;
        try {
            spaces = this.queryManager.getNamedQuery("getSpaces").setWiki(wikiReference.getName()).execute();
        }
        catch (QueryException e) {
            throw new SolrIndexerException("Failed to query wiki [" + wikiReference.getName() + "] spaces", (Exception)((Object)e));
        }
        for (String space : spaces) {
            SpaceReference spaceReference = new SpaceReference(space, wikiReference);
            try {
                Iterables.addAll(result, ((SolrReferenceResolver)this.spaceResolverProvider.get()).getReferences((EntityReference)spaceReference));
            }
            catch (Exception e) {
                this.logger.error("Failed to resolve references for space [" + spaceReference + "]", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getQuery(EntityReference reference) {
        return "wiki:" + ClientUtils.escapeQueryChars((String)reference.getName());
    }
}

