/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.search.solr.internal.api.SolrFieldNameEncoder;

@Component
@Singleton
public class DefaultSolrFieldNameEncoder
implements SolrFieldNameEncoder {
    private static final char ESCAPE = '$';
    private static final int CASE_DIFF = 32;
    private static final String UTF8 = "UTF-8";

    @Override
    public String encode(String fieldName) {
        char[] chars;
        if (fieldName == null) {
            return null;
        }
        int length = fieldName.length();
        StringBuilder output = new StringBuilder(length);
        boolean dirty = false;
        for (int offset = 0; offset < length; offset += chars.length) {
            int codePoint = fieldName.codePointAt(offset);
            chars = Character.toChars(codePoint);
            if (this.needsEncoding(codePoint)) {
                this.encode(chars, output);
                dirty = true;
                continue;
            }
            output.append(chars);
        }
        return dirty ? output.toString() : fieldName;
    }

    @Override
    public String decode(String fieldName) {
        try {
            if (fieldName != null) {
                return URLDecoder.decode(fieldName.replace('$', '%'), UTF8);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    protected boolean needsEncoding(int codePoint) {
        return codePoint == 36 || !Character.isJavaIdentifierPart(codePoint) && codePoint != 45 && codePoint != 46;
    }

    protected void encode(char[] chars, StringBuilder output) {
        try {
            byte[] bytes = new String(chars).getBytes(UTF8);
            int length = bytes.length;
            for (int i = 0; i < length; ++i) {
                output.append('$');
                char ch = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                output.append(ch);
                ch = Character.forDigit(bytes[i] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                output.append(ch);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

