/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.search.solr.internal.AbstractSolrInstance;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="embedded")
@Singleton
public class EmbeddedSolrInstance
extends AbstractSolrInstance
implements Disposable {
    public static final String TYPE = "embedded";
    public static final String DEFAULT_SOLR_DIRECTORY_NAME = "solr";
    @Inject
    private SolrConfiguration solrConfiguration;
    @Inject
    private Environment environment;
    private CoreContainer container;

    public void initialize() throws InitializationException {
        String solrHome = this.determineHomeDirectory();
        try {
            this.validateAndInitializeHomeDirectory(solrHome);
            this.logger.info("Starting embedded Solr server...");
            this.logger.info("Using Solr home directory: [{}]", (Object)solrHome);
            this.container = this.createCoreContainer(solrHome);
            String coreName = ((SolrCore)this.container.getCores().iterator().next()).getName();
            this.server = new EmbeddedSolrServer(this.container, coreName);
            this.logger.info("Started embedded Solr server.");
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Failed to initialize the Solr embedded server with home directory set to [%s]", solrHome), (Throwable)e);
        }
    }

    private CoreContainer createCoreContainer(String solrHome) throws SolrServerException {
        CoreContainer coreContainer = new CoreContainer(solrHome);
        coreContainer.load();
        if (coreContainer.getCores().size() == 0) {
            throw new SolrServerException("Failed to initialize the Solr core. Please check the configuration and log messages.");
        }
        if (coreContainer.getCores().size() > 1) {
            this.logger.warn("Multiple Solr cores detected: [{}]. Using the first one.", (Object)StringUtils.join((Iterable)coreContainer.getCoreNames(), (String)", "));
        }
        return coreContainer;
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.server != null) {
            this.server.shutdown();
        }
        if (this.container != null) {
            this.container.shutdown();
        }
    }

    protected CoreContainer getContainer() {
        return this.container;
    }

    private void validateAndInitializeHomeDirectory(String solrHome) throws IllegalArgumentException, IOException {
        File solrHomeDirectory = new File(solrHome);
        if (solrHomeDirectory.exists()) {
            if (!(solrHomeDirectory.isDirectory() && solrHomeDirectory.canWrite() && solrHomeDirectory.canRead())) {
                throw new IllegalArgumentException(String.format("The given path [%s] must be a readable and writable directory", solrHomeDirectory));
            }
        } else {
            if (!solrHomeDirectory.mkdirs()) {
                throw new IllegalArgumentException(String.format("The given path [%s] could not be created due to and invalid value %s", solrHomeDirectory, "or to insufficient filesystem permissions"));
            }
            Map<String, URL> homeDirectoryConfiguration = this.solrConfiguration.getHomeDirectoryConfiguration();
            for (Map.Entry<String, URL> file : homeDirectoryConfiguration.entrySet()) {
                File destinationFile = new File(solrHomeDirectory, file.getKey());
                FileUtils.copyURLToFile((URL)file.getValue(), (File)destinationFile);
            }
        }
    }

    private String determineHomeDirectory() {
        String defaultValue = this.getDefaultHomeDirectory();
        return this.solrConfiguration.getInstanceConfiguration(TYPE, "home", defaultValue);
    }

    String getDefaultHomeDirectory() {
        String result = new File(this.environment.getPermanentDirectory(), DEFAULT_SOLR_DIRECTORY_NAME).getPath();
        return result;
    }
}

