/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AbstractAttachmentEvent;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.internal.event.EntityEvent;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyAddedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.search.solr.internal.api.SolrIndexer;

@Component
@Named(value="solr.update")
@Singleton
public class SolrIndexEventListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent(), new DocumentCreatedEvent(), new DocumentDeletedEvent(), new AttachmentAddedEvent(), new AttachmentDeletedEvent(), new AttachmentUpdatedEvent(), new XObjectAddedEvent(), new XObjectDeletedEvent(), new XObjectUpdatedEvent(), new XObjectPropertyAddedEvent(), new XObjectPropertyDeletedEvent(), new XObjectPropertyUpdatedEvent(), new WikiDeletedEvent());
    @Inject
    protected Logger logger;
    @Inject
    private Provider<SolrIndexer> solrIndexer;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void onEvent(Event event, Object source, Object data) {
        try {
            if (event instanceof DocumentUpdatedEvent) {
                XWikiDocument document = (XWikiDocument)source;
                ((SolrIndexer)this.solrIndexer.get()).index((EntityReference)document.getDocumentReferenceWithLocale(), false);
            } else if (event instanceof DocumentCreatedEvent) {
                XWikiDocument document = (XWikiDocument)source;
                if (!Locale.ROOT.equals(document.getLocale())) {
                    ((SolrIndexer)this.solrIndexer.get()).index((EntityReference)new DocumentReference((EntityReference)document.getDocumentReference(), null), true);
                } else {
                    ((SolrIndexer)this.solrIndexer.get()).index((EntityReference)document.getDocumentReferenceWithLocale(), false);
                }
            } else if (event instanceof DocumentDeletedEvent) {
                XWikiDocument document = ((XWikiDocument)source).getOriginalDocument();
                ((SolrIndexer)this.solrIndexer.get()).delete((EntityReference)new DocumentReference((EntityReference)document.getDocumentReference(), document.getRealLocale()), false);
            } else if (event instanceof AttachmentUpdatedEvent || event instanceof AttachmentAddedEvent) {
                XWikiDocument document = (XWikiDocument)source;
                String fileName = ((AbstractAttachmentEvent)event).getName();
                XWikiAttachment attachment = document.getAttachment(fileName);
                ((SolrIndexer)this.solrIndexer.get()).index((EntityReference)attachment.getReference(), false);
            } else if (event instanceof AttachmentDeletedEvent) {
                XWikiDocument document = ((XWikiDocument)source).getOriginalDocument();
                String fileName = ((AbstractAttachmentEvent)event).getName();
                XWikiAttachment attachment = document.getAttachment(fileName);
                ((SolrIndexer)this.solrIndexer.get()).delete((EntityReference)attachment.getReference(), false);
            } else if (event instanceof XObjectUpdatedEvent || event instanceof XObjectAddedEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                ((SolrIndexer)this.solrIndexer.get()).index(entityEvent.getReference(), false);
            } else if (event instanceof XObjectDeletedEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                ((SolrIndexer)this.solrIndexer.get()).delete(entityEvent.getReference(), false);
            } else if (event instanceof XObjectPropertyUpdatedEvent || event instanceof XObjectPropertyAddedEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                ((SolrIndexer)this.solrIndexer.get()).index(entityEvent.getReference(), false);
            } else if (event instanceof XObjectPropertyDeletedEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                ((SolrIndexer)this.solrIndexer.get()).delete(entityEvent.getReference(), false);
            } else if (event instanceof WikiDeletedEvent) {
                String wikiName = (String)source;
                WikiReference wikiReference = new WikiReference(wikiName);
                ((SolrIndexer)this.solrIndexer.get()).delete((EntityReference)wikiReference, false);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to handle event [{}] with source [{}]", new Object[]{event, source, e});
        }
    }
}

