/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.api;

import java.util.Locale;

public final class FieldUtils {
    public static final String SORT_SUFFIX = "_sort";
    public static final String ID = "id";
    public static final String LANGUAGE = "language";
    public static final String LOCALE = "locale";
    public static final String DOCUMENT_LOCALE = "doclocale";
    public static final String LOCALES = "locales";
    public static final String WIKI = "wiki";
    public static final String SPACE = "space";
    public static final String SPACE_EXACT = "space_exact";
    public static final String NAME = "name";
    public static final String NAME_EXACT = "name_exact";
    public static final String FULLNAME = "fullname";
    public static final String TITLE = "title";
    public static final String TITLE_SORT = "title_sort";
    public static final String VERSION = "version";
    public static final String COMMENT = "comment";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String NUMBER = "number";
    public static final String OBJECT_CONTENT = "objcontent";
    public static final String AUTHOR = "author";
    public static final String AUTHOR_DISPLAY = "author_display";
    public static final String AUTHOR_DISPLAY_SORT = "author_display_sort";
    public static final String CREATOR = "creator";
    public static final String CREATOR_DISPLAY = "creator_display";
    public static final String DATE = "date";
    public static final String CREATIONDATE = "creationdate";
    public static final String HIDDEN = "hidden";
    public static final String SCORE = "score";
    public static final String DOCUMENT_RENDERED_CONTENT = "doccontent";
    public static final String DOCUMENT_RAW_CONTENT = "doccontentraw";
    public static final String ATTACHMENT_CONTENT = "attcontent";
    public static final String ATTACHMENT_VERSION = "attversion";
    public static final String ATTACHMENT_DATE = "attdate";
    public static final String ATTACHMENT_DATE_SORT = "attdate_sort";
    public static final String ATTACHMENT_SIZE = "attsize";
    public static final String ATTACHMENT_SIZE_SORT = "attsize_sort";
    public static final String ATTACHMENT_AUTHOR = "attauthor";
    public static final String ATTACHMENT_AUTHOR_DISPLAY = "attauthor_display";
    public static final String ATTACHMENT_AUTHOR_DISPLAY_SORT = "attauthor_display_sort";
    public static final String MIME_TYPE = "mimetype";
    public static final String FILENAME = "filename";
    public static final String FILENAME_SORT = "filename_sort";
    public static final String PROPERTY_NAME = "propertyname";
    public static final String PROPERTY_VALUE = "propertyvalue";
    public static final String USCORE = "_";

    private FieldUtils() {
    }

    public static String getFieldName(String field, Locale locale) {
        StringBuilder builder = new StringBuilder(field);
        builder.append(USCORE);
        if (locale != null) {
            if (locale.equals(Locale.ROOT)) {
                builder.append(USCORE);
            } else {
                builder.append(locale);
            }
        }
        return builder.toString();
    }

    public static String getFieldName(String prefix, String type, Locale locale) {
        if (type != null) {
            return prefix + USCORE + type;
        }
        return FieldUtils.getFieldName(prefix, locale);
    }
}

