/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Singleton
public class SolrInstanceProvider
implements Provider<SolrInstance>,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    private SolrInstance configuredInstance;

    public void initialize() throws InitializationException {
        String type = this.configuration.getServerType();
        try {
            this.configuredInstance = (SolrInstance)this.componentManager.getInstance(SolrInstance.class, type);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(String.format("Failed to lookup configured Solr instance type [%s]", type), (Throwable)e);
        }
    }

    public SolrInstance get() {
        return this.configuredInstance;
    }
}

