/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.job.DiffDocumentIterator;
import org.xwiki.search.solr.internal.job.DocumentIterator;
import org.xwiki.search.solr.internal.job.IndexerRequest;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="solr.indexer")
public class IndexerJob
extends AbstractJob<IndexerRequest, DefaultJobStatus<IndexerRequest>> {
    public static final String JOBTYPE = "solr.indexer";
    @Inject
    private transient SolrIndexer indexer;
    @Inject
    @Named(value="database")
    private transient DocumentIterator<String> databaseIterator;
    @Inject
    @Named(value="solr")
    private transient DocumentIterator<String> solrIterator;

    public String getType() {
        return JOBTYPE;
    }

    protected IndexerRequest castRequest(Request request) {
        IndexerRequest indexerRequest = request instanceof IndexerRequest ? (IndexerRequest)request : new IndexerRequest(request);
        return indexerRequest;
    }

    protected void runInternal() throws Exception {
        if (((IndexerRequest)this.getRequest()).isOverwrite()) {
            EntityReference rootReference = ((IndexerRequest)this.getRequest()).getRootReference();
            this.logger.info("Index documents in [{}].", (Object)rootReference);
            this.indexer.index(rootReference, true);
        } else {
            this.updateSolrIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSolrIndex() {
        DiffDocumentIterator<String> iterator = new DiffDocumentIterator<String>(this.solrIterator, this.databaseIterator);
        iterator.setRootReference(((IndexerRequest)this.getRequest()).getRootReference());
        this.progressManager.pushLevelProgress((int)iterator.size(), (Object)this);
        try {
            long[] counter = new long[4];
            while (iterator.hasNext()) {
                this.progressManager.startStep((Object)this);
                Pair<DocumentReference, DiffDocumentIterator.Action> entry = iterator.next();
                if (entry.getValue() == DiffDocumentIterator.Action.ADD || entry.getValue() == DiffDocumentIterator.Action.UPDATE) {
                    this.indexer.index((EntityReference)entry.getKey(), true);
                } else if (entry.getValue() == DiffDocumentIterator.Action.DELETE && ((IndexerRequest)this.getRequest()).isRemoveMissing()) {
                    this.indexer.delete((EntityReference)entry.getKey(), true);
                }
                int n = ((DiffDocumentIterator.Action)((Object)entry.getValue())).ordinal();
                counter[n] = counter[n] + 1L;
            }
            this.logger.info("{} documents added, {} deleted and {} updated during the synchronization of the Solr index.", new Object[]{counter[DiffDocumentIterator.Action.ADD.ordinal()], counter[DiffDocumentIterator.Action.DELETE.ordinal()], counter[DiffDocumentIterator.Action.UPDATE.ordinal()]});
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

