/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.LengthSolrInputDocument;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="object")
@Singleton
public class ObjectSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    @Named(value="object")
    private SolrReferenceResolver resolver;

    @Override
    public boolean setFieldsInternal(LengthSolrInputDocument solrDocument, EntityReference entityReference) throws Exception {
        BaseObjectReference objectReference = new BaseObjectReference(entityReference);
        DocumentReference classReference = objectReference.getXClassReference();
        DocumentReference documentReference = new DocumentReference(objectReference.getParent());
        XWikiDocument document = this.getDocument(documentReference);
        BaseObject object = document.getXObject((ObjectReference)objectReference);
        if (object == null) {
            return false;
        }
        solrDocument.setField("id", this.resolver.getId(object.getReference()));
        this.setDocumentFields(documentReference, solrDocument);
        solrDocument.setField("type", objectReference.getType().name());
        solrDocument.setField("class", this.localSerializer.serialize((EntityReference)classReference, new Object[0]));
        solrDocument.setField("number", objectReference.getObjectNumber());
        this.setLocaleAndContentFields(documentReference, solrDocument, object);
        return true;
    }

    protected void setLocaleAndContentFields(DocumentReference documentReference, SolrInputDocument solrDocument, BaseObject object) throws Exception {
        for (Locale documentLocale : this.getLocales(documentReference, null)) {
            solrDocument.addField("locales", (Object)documentLocale);
            this.setObjectContent(solrDocument, object, documentLocale);
        }
        this.setObjectContent(solrDocument, object, null);
    }
}

