/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import java.lang.reflect.Type;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component
@Singleton
public class SolrEntityReferenceResolver
implements EntityReferenceResolver<SolrDocument> {
    public static final Type TYPE = new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{SolrDocument.class});
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<EntityReference> explicitReferenceEntityReferenceResolver;

    public EntityReference resolve(SolrDocument solrDocument, EntityType type, Object ... parameters) {
        EntityReference solrEntityReference = this.getEntityReference(solrDocument, type, parameters);
        return this.explicitReferenceEntityReferenceResolver.resolve((Object)solrEntityReference, type, parameters);
    }

    private EntityReference getEntityReference(SolrDocument solrDocument, EntityType expectedEntityType, Object ... parameters) {
        EntityReference wikiReference = this.getWikiReference(solrDocument, parameters);
        EntityReference spaceReference = this.getSpaceReference(solrDocument, wikiReference, parameters);
        EntityReference documentReference = this.getDocumentReferenceWithLocale(solrDocument, spaceReference, parameters);
        String indexedEntityType = this.getFieldStringValue(solrDocument, "type");
        EntityType actualEntityType = StringUtils.isEmpty((CharSequence)indexedEntityType) ? expectedEntityType : EntityType.valueOf((String)indexedEntityType);
        switch (actualEntityType) {
            case ATTACHMENT: {
                return this.getAttachmentReference(solrDocument, documentReference, parameters);
            }
            case OBJECT: {
                return this.getObjectReference(solrDocument, documentReference, parameters);
            }
            case OBJECT_PROPERTY: {
                EntityReference objectReference = this.getObjectReference(solrDocument, documentReference, parameters);
                return this.getObjectPropertyReference(solrDocument, objectReference, parameters);
            }
        }
        return documentReference;
    }

    private EntityReference getWikiReference(SolrDocument solrDocument, Object ... parameters) {
        String wikiName = this.getFieldStringValue(solrDocument, "wiki");
        if (!StringUtils.isEmpty((CharSequence)wikiName)) {
            return new EntityReference(wikiName, EntityType.WIKI);
        }
        return this.resolveMissingReference(EntityType.WIKI, null, parameters);
    }

    private EntityReference getSpaceReference(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        Collection spaceNames = solrDocument.getFieldValues("spaces");
        if (spaceNames != null && !spaceNames.isEmpty()) {
            EntityReference spaceReference = parent;
            for (Object spaceName : spaceNames) {
                spaceReference = new EntityReference(String.valueOf(spaceName), EntityType.SPACE, spaceReference);
            }
            return spaceReference;
        }
        return this.resolveMissingReference(EntityType.SPACE, parent, parameters);
    }

    private EntityReference getDocumentReferenceWithLocale(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        EntityReference documentReference = this.getDocumentReference(solrDocument, parent, parameters);
        String localeString = this.getFieldStringValue(solrDocument, "doclocale");
        if (!StringUtils.isEmpty((CharSequence)localeString)) {
            documentReference = new DocumentReference(documentReference, LocaleUtils.toLocale((String)localeString));
        }
        return documentReference;
    }

    private EntityReference getDocumentReference(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        String documentName = this.getFieldStringValue(solrDocument, "name");
        if (!StringUtils.isEmpty((CharSequence)documentName)) {
            return new EntityReference(documentName, EntityType.DOCUMENT, parent);
        }
        return this.resolveMissingReference(EntityType.DOCUMENT, parent, parameters);
    }

    private EntityReference getAttachmentReference(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        String fileName = this.getFieldFirstStringValue(solrDocument, "filename");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            return new EntityReference(fileName, EntityType.ATTACHMENT, parent);
        }
        return this.resolveMissingReference(EntityType.ATTACHMENT, parent, parameters);
    }

    private EntityReference getObjectReference(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        String classReference = this.getFieldFirstStringValue(solrDocument, "class");
        Number objectNumber = this.getFieldNumberValue(solrDocument, "number");
        if (!StringUtils.isEmpty((CharSequence)classReference) && objectNumber != null) {
            return new EntityReference(String.format("%s[%s]", classReference, objectNumber), EntityType.OBJECT, parent);
        }
        return this.resolveMissingReference(EntityType.OBJECT, parent, parameters);
    }

    private EntityReference getObjectPropertyReference(SolrDocument solrDocument, EntityReference parent, Object ... parameters) {
        String propertyName = this.getFieldStringValue(solrDocument, "propertyname");
        if (!StringUtils.isEmpty((CharSequence)propertyName)) {
            return new EntityReference(propertyName, EntityType.OBJECT_PROPERTY, parent);
        }
        return this.resolveMissingReference(EntityType.OBJECT_PROPERTY, parent, parameters);
    }

    private EntityReference resolveMissingReference(EntityType entityType, EntityReference parent, Object ... parameters) {
        EntityReference entityReference = this.explicitReferenceEntityReferenceResolver.resolve(null, entityType, parameters);
        return entityReference.replaceParent(entityReference.getParent(), parent);
    }

    private String getFieldStringValue(SolrDocument solrDocument, String fieldName) {
        Object field = solrDocument.get((Object)fieldName);
        if (field instanceof Field) {
            return ((Field)field).stringValue();
        }
        if (field instanceof IndexableField) {
            return ((IndexableField)field).stringValue();
        }
        return field != null ? field.toString() : null;
    }

    private String getFieldFirstStringValue(SolrDocument solrDocument, String fieldName) {
        Object field = solrDocument.getFirstValue(fieldName);
        if (field instanceof Field) {
            return ((Field)field).stringValue();
        }
        if (field instanceof IndexableField) {
            return ((IndexableField)field).stringValue();
        }
        return field != null ? field.toString() : null;
    }

    private Number getFieldNumberValue(SolrDocument solrDocument, String fieldName) {
        Object field = solrDocument.get((Object)fieldName);
        if (field instanceof Field) {
            return ((Field)field).numericValue();
        }
        if (field instanceof IndexableField) {
            return ((IndexableField)field).numericValue();
        }
        return field != null ? (Number)((Number)field) : (Number)null;
    }
}

