/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.AbstractSolrReferenceResolver;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="space")
@Singleton
public class SpaceSolrReferenceResolver
extends AbstractSolrReferenceResolver {
    @Inject
    @Named(value="document")
    private Provider<SolrReferenceResolver> documentResolverProvider;
    @Inject
    @Named(value="wiki")
    private Provider<SolrReferenceResolver> wikiResolverProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;

    public List<EntityReference> getReferences(EntityReference spaceReference) throws SolrIndexerException {
        List documentNames;
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        EntityReference wikiReference = spaceReference.extractReference(EntityType.WIKI);
        String localSpaceReference = (String)this.localEntityReferenceSerializer.serialize(spaceReference, new Object[0]);
        try {
            documentNames = this.queryManager.getNamedQuery("getSpaceDocsName").setWiki(wikiReference.getName()).bindValue("space", (Object)localSpaceReference).execute();
        }
        catch (QueryException e) {
            throw new SolrIndexerException("Failed to query space [" + spaceReference + "] documents", (Exception)((Object)e));
        }
        for (String documentName : documentNames) {
            EntityReference documentReference = new EntityReference(documentName, EntityType.DOCUMENT, spaceReference);
            try {
                Iterables.addAll(result, ((SolrReferenceResolver)this.documentResolverProvider.get()).getReferences(documentReference));
            }
            catch (Exception e) {
                this.logger.error("Failed to resolve references for document [" + documentReference + "]", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getQuery(EntityReference reference) throws SolrIndexerException {
        StringBuilder builder = new StringBuilder();
        EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
        builder.append(((SolrReferenceResolver)this.wikiResolverProvider.get()).getQuery(wikiReference));
        builder.append(" AND ");
        builder.append("space_exact");
        builder.append(':');
        String localSpaceReference = (String)this.localEntityReferenceSerializer.serialize(reference, new Object[0]);
        builder.append(ClientUtils.escapeQueryChars((String)localSpaceReference));
        return builder.toString();
    }
}

