/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.solr.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Named(value="solr")
public class SolrQueryExecutor
implements QueryExecutor {
    public static final String SOLR = "solr";
    @Inject
    protected Logger logger;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="user")
    protected ConfigurationSource userPreferencesSource;
    @Inject
    protected Provider<SolrInstance> solrInstanceProvider;

    public <T> List<T> execute(Query query) throws QueryException {
        try {
            SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
            SolrQuery solrQuery = new SolrQuery(query.getStatement());
            if (query.getOffset() > 0) {
                solrQuery.setStart(Integer.valueOf(query.getOffset()));
            }
            if (query.getLimit() > 0) {
                solrQuery.setRows(Integer.valueOf(query.getLimit()));
            }
            for (Map.Entry entry : query.getNamedParameters().entrySet()) {
                solrQuery.set((String)entry.getKey(), new String[]{String.valueOf(entry.getValue())});
            }
            QueryResponse response = solrInstance.query((SolrParams)solrQuery);
            this.filterResponse(response);
            return Arrays.asList(response);
        }
        catch (Exception e) {
            throw new QueryException("Exception while executing query", query, (Throwable)e);
        }
    }

    protected void filterResponse(QueryResponse response) {
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        for (SolrDocument result : new ArrayList(results)) {
            try {
                DocumentReference resultDocumentReference = new DocumentReference((String)result.get((Object)"wiki"), (String)result.get((Object)"space"), (String)result.get((Object)"name"));
                if (this.documentAccessBridge.exists(resultDocumentReference) && this.documentAccessBridge.isDocumentViewable(resultDocumentReference)) continue;
                results.remove((Object)result);
                --numFound;
            }
            catch (Exception e) {
                this.logger.warn("Skipping bad result: {}", (Object)result, (Object)e);
            }
        }
        if (numFound < 0L) {
            numFound = 0L;
        }
        results.setNumFound(numFound);
    }
}

