/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.RightDescription;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;

public class Right
implements RightDescription,
Serializable,
Comparable<Right> {
    public static final Right LOGIN;
    public static final Right VIEW;
    public static final Right EDIT;
    public static final Right DELETE;
    public static final Right CREATOR;
    public static final Right ADMIN;
    public static final Right PROGRAM;
    public static final Right SCRIPT;
    public static final Right REGISTER;
    public static final Right COMMENT;
    public static final Right CREATE_WIKI;
    public static final Right ILLEGAL;
    public static final String ILLEGAL_RIGHT_NAME = "illegal";
    public static final Set<EntityType> FARM_ONLY;
    public static final Set<EntityType> WIKI_ONLY;
    public static final Set<EntityType> WIKI_SPACE;
    public static final Set<EntityType> WIKI_SPACE_DOCUMENT;
    private static final long serialVersionUID = 1L;
    private static final List<Right> VALUES;
    private static final List<Right> UNMODIFIABLE_VALUES;
    private static final List<String> ALL_RIGHTS;
    private static final List<String> UNMODIFIABLE_ALL_RIGHTS;
    private static final Map<EntityType, Set<Right>> ENABLED_RIGHTS;
    private static final Map<EntityType, Set<Right>> UNMODIFIABLE_ENABLED_RIGHTS;
    private final int value;
    private final String name;
    private final RuleState defaultState;
    private final RuleState tieResolutionPolicy;
    private final boolean inheritanceOverridePolicy;
    private final Set<Right> impliedRights;
    private final boolean isReadOnly;

    Right(RightDescription description) {
        this(description.getName(), description.getDefaultState(), description.getTieResolutionPolicy(), description.getInheritanceOverridePolicy(), description.getImpliedRights(), description.getTargetedEntityType(), description.isReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Right(String name, RuleState defaultState, RuleState tieResolutionPolicy, boolean inheritanceOverridePolicy, Set<Right> impliedRights, Set<EntityType> validEntityTypes, boolean isReadOnly) {
        this.checkIllegalArguments(name, defaultState, tieResolutionPolicy);
        this.name = name;
        this.defaultState = defaultState;
        this.tieResolutionPolicy = tieResolutionPolicy;
        this.inheritanceOverridePolicy = inheritanceOverridePolicy;
        this.impliedRights = this.cloneImpliedRights(impliedRights);
        this.isReadOnly = isReadOnly;
        List<Right> list = VALUES;
        synchronized (list) {
            this.value = VALUES.size();
            if (this.value >= 64) {
                throw new IndexOutOfBoundsException();
            }
            VALUES.add(this);
            if (!name.equals(ILLEGAL_RIGHT_NAME)) {
                ALL_RIGHTS.add(name);
            }
            if (validEntityTypes != null) {
                for (EntityType type : validEntityTypes) {
                    if (type == EntityType.WIKI) {
                        this.enableFor(SecurityReference.FARM);
                    }
                    this.enableFor(type);
                }
            } else {
                this.enableFor(SecurityReference.FARM);
            }
        }
    }

    private void enableFor(EntityType type) {
        RightSet rights = ENABLED_RIGHTS.get(type);
        if (rights == null) {
            rights = new RightSet();
            ENABLED_RIGHTS.put(type, rights);
            UNMODIFIABLE_ENABLED_RIGHTS.put(type, Collections.unmodifiableSet(rights));
        }
        rights.add((Right)this);
    }

    private void checkIllegalArguments(String name, RuleState defaultState, RuleState tieResolutionPolicy) {
        if (name == null || ALL_RIGHTS.contains(name) || ILLEGAL != null && name.equals(ILLEGAL_RIGHT_NAME)) {
            throw new IllegalArgumentException(String.format("Duplicate name for right [%s]", name));
        }
        if (defaultState == null || defaultState == RuleState.UNDETERMINED) {
            throw new IllegalArgumentException(String.format("Invalid default state [%s] for right [%s]", new Object[]{defaultState, name}));
        }
        if (tieResolutionPolicy == null || tieResolutionPolicy == RuleState.UNDETERMINED) {
            throw new IllegalArgumentException(String.format("Invalid tie resolution policy [%s] for right [%s]", new Object[]{tieResolutionPolicy, name}));
        }
    }

    private Set<Right> cloneImpliedRights(Set<Right> impliedRights) {
        if (impliedRights == null || impliedRights.size() == 0) {
            return null;
        }
        RightSet implied = new RightSet(impliedRights);
        if (implied.size() > 0) {
            return Collections.unmodifiableSet(implied);
        }
        return null;
    }

    public static List<Right> values() {
        return UNMODIFIABLE_VALUES;
    }

    public static Right toRight(String string) {
        for (Right right : VALUES) {
            if (!right.name.equalsIgnoreCase(string)) continue;
            return right;
        }
        return ILLEGAL;
    }

    public static Set<Right> getEnabledRights(EntityType entityType) {
        Set<Right> enabledRights = UNMODIFIABLE_ENABLED_RIGHTS.get(entityType);
        if (enabledRights == null) {
            enabledRights = Collections.emptySet();
        }
        return enabledRights;
    }

    public static Right get(int ordinal) {
        return VALUES.get(ordinal);
    }

    public static int size() {
        return Right.values().size();
    }

    public static List<String> getAllRightsAsString() {
        return UNMODIFIABLE_ALL_RIGHTS;
    }

    public int ordinal() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Set<Right> getImpliedRights() {
        return this.impliedRights;
    }

    @Override
    public Set<EntityType> getTargetedEntityType() {
        ArrayList<EntityType> levels = new ArrayList<EntityType>();
        for (Map.Entry<EntityType, Set<Right>> entry : ENABLED_RIGHTS.entrySet()) {
            if (!entry.getValue().contains(this)) continue;
            levels.add(entry.getKey());
        }
        if (levels.contains(null)) {
            if (levels.contains(EntityType.WIKI)) {
                levels.remove(null);
            } else {
                return null;
            }
        }
        return EnumSet.copyOf(levels);
    }

    @Override
    public boolean getInheritanceOverridePolicy() {
        return this.inheritanceOverridePolicy;
    }

    @Override
    public RuleState getTieResolutionPolicy() {
        return this.tieResolutionPolicy;
    }

    @Override
    public RuleState getDefaultState() {
        return this.defaultState;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public int compareTo(Right other) {
        return this.ordinal() - other.ordinal();
    }

    boolean like(RightDescription description) {
        return new EqualsBuilder().append(this.isReadOnly(), description.isReadOnly()).append((Object)this.getDefaultState(), (Object)description.getDefaultState()).append((Object)this.getTieResolutionPolicy(), (Object)description.getTieResolutionPolicy()).append(this.getInheritanceOverridePolicy(), description.getInheritanceOverridePolicy()).append(this.getTargetedEntityType(), description.getTargetedEntityType()).isEquals() && this.likeImpliedRightsFrom(description);
    }

    private boolean likeImpliedRightsFrom(RightDescription description) {
        Set<Right> otherImpliedRights;
        Set<Right> localImpliedRights = this.getImpliedRights();
        boolean result = new EqualsBuilder().append(localImpliedRights, otherImpliedRights = description.getImpliedRights()).isEquals();
        if (!result) {
            result = localImpliedRights == null && otherImpliedRights.isEmpty() || otherImpliedRights == null && localImpliedRights.isEmpty();
        }
        return result;
    }

    static {
        FARM_ONLY = null;
        WIKI_ONLY = EnumSet.of(EntityType.WIKI);
        WIKI_SPACE = EnumSet.of(EntityType.WIKI, EntityType.SPACE);
        WIKI_SPACE_DOCUMENT = EnumSet.of(EntityType.WIKI, EntityType.SPACE, EntityType.DOCUMENT);
        VALUES = new ArrayList<Right>();
        UNMODIFIABLE_VALUES = Collections.unmodifiableList(VALUES);
        ALL_RIGHTS = new LinkedList<String>();
        UNMODIFIABLE_ALL_RIGHTS = Collections.unmodifiableList(ALL_RIGHTS);
        ENABLED_RIGHTS = new HashMap<EntityType, Set<Right>>();
        UNMODIFIABLE_ENABLED_RIGHTS = new HashMap<EntityType, Set<Right>>();
        LOGIN = new Right("login", RuleState.ALLOW, RuleState.ALLOW, true, null, WIKI_ONLY, true);
        VIEW = new Right("view", RuleState.ALLOW, RuleState.DENY, true, null, WIKI_SPACE_DOCUMENT, true);
        EDIT = new Right("edit", RuleState.ALLOW, RuleState.DENY, true, new RightSet(VIEW), WIKI_SPACE_DOCUMENT, false);
        DELETE = new Right("delete", RuleState.DENY, RuleState.DENY, true, null, WIKI_SPACE_DOCUMENT, false);
        CREATOR = new Right("creator", RuleState.DENY, RuleState.ALLOW, false, new RightSet(DELETE), EnumSet.of(EntityType.DOCUMENT), false);
        REGISTER = new Right("register", RuleState.ALLOW, RuleState.ALLOW, true, null, WIKI_ONLY, false);
        COMMENT = new Right("comment", RuleState.ALLOW, RuleState.DENY, true, null, WIKI_SPACE_DOCUMENT, false);
        SCRIPT = new Right("script", RuleState.DENY, RuleState.DENY, true, null, WIKI_SPACE_DOCUMENT, true);
        ADMIN = new Right("admin", RuleState.DENY, RuleState.ALLOW, false, new RightSet(LOGIN, VIEW, SCRIPT, EDIT, DELETE, REGISTER, COMMENT), WIKI_SPACE, true);
        CREATE_WIKI = new Right("createwiki", RuleState.DENY, RuleState.DENY, true, null, FARM_ONLY, false);
        PROGRAM = new Right("programming", RuleState.DENY, RuleState.ALLOW, false, new RightSet(LOGIN, VIEW, SCRIPT, EDIT, DELETE, REGISTER, COMMENT, ADMIN, CREATE_WIKI), FARM_ONLY, true);
        ILLEGAL = new Right(ILLEGAL_RIGHT_NAME, RuleState.DENY, RuleState.DENY, false, null, null, false);
    }
}

