/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.security.authorization;

/**
 * Provide the allow/deny/undetermined state of a full set of rights.
 *
 * @version $Id: 6fe9d98982dcff21a6dfaf82b919e076973d888a $
 * @since 4.0M2 
 */
public interface SecurityAccess extends Cloneable
{
    /**
     * Return the rule state of a given {@link Right}.
     * @param right the right to retrieve.
     * @return the state of this right.
     */
    RuleState get(Right right);
}
