/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightDescription;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityAccess;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.UnableToRegisterRightException;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.internal.XWikiBridge;

@Component
@Singleton
public class DefaultAuthorizationManager
implements AuthorizationManager {
    private static final List<Right> DEFAULT_IMPLIED_BY_RIGHTS = Arrays.asList(Right.ADMIN, Right.PROGRAM);
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityCacheLoader securityCacheLoader;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private XWikiBridge xwikiBridge;

    private boolean isSuperAdmin(DocumentReference user) {
        return user != null && StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)"superadmin");
    }

    @Override
    public void checkAccess(Right right, DocumentReference userReference, EntityReference entityReference) throws AccessDeniedException {
        try {
            if (!this.hasSecurityAccess(right, userReference, entityReference, true)) {
                throw new AccessDeniedException(right, userReference, entityReference);
            }
        }
        catch (Exception e) {
            if (e instanceof AccessDeniedException) {
                throw (AccessDeniedException)e;
            }
            throw new AccessDeniedException(right, userReference, entityReference, (Throwable)e);
        }
    }

    @Override
    public boolean hasAccess(Right right, DocumentReference userReference, EntityReference entityReference) {
        try {
            return this.hasSecurityAccess(right, userReference, entityReference, false);
        }
        catch (Exception e) {
            this.logger.error(String.format("Failed to load rights for user [%s] on [%s].", userReference == null ? "Public" : userReference, entityReference == null ? "Main Wiki" : entityReference), (Throwable)e);
            return false;
        }
    }

    private boolean hasSecurityAccess(Right right, DocumentReference userReference, EntityReference entityReference, boolean check) throws AuthorizationException {
        if (this.isSuperAdmin(userReference)) {
            return true;
        }
        if (right == null || right == Right.ILLEGAL) {
            if (check) {
                this.logDeny(userReference, entityReference, right, "no such right");
            }
            return false;
        }
        if (!right.isReadOnly() && this.xwikiBridge.isWikiReadOnly() || userReference == null && this.xwikiBridge.needsAuthentication(right)) {
            return false;
        }
        return this.evaluateSecurityAccess(right, userReference, entityReference, check);
    }

    private boolean evaluateSecurityAccess(Right right, DocumentReference userReference, EntityReference entityReference, boolean check) throws AuthorizationException {
        String info;
        SecurityAccess securityAccess = this.getAccess(this.securityReferenceFactory.newUserReference(userReference), this.securityReferenceFactory.newEntityReference(entityReference));
        RuleState access = securityAccess.get(right);
        String string = info = check ? "security checkpoint" : "access inquiry";
        if (check && access != RuleState.ALLOW) {
            this.logDeny(userReference, entityReference, right, info);
        } else {
            this.logAccess(access, userReference, entityReference, right, info, true);
        }
        return access == RuleState.ALLOW;
    }

    @Override
    public Right register(RightDescription rightDescription) throws UnableToRegisterRightException {
        return this.register(rightDescription, new HashSet<Right>(DEFAULT_IMPLIED_BY_RIGHTS));
    }

    @Override
    public Right register(RightDescription rightDescription, Set<Right> impliedByRights) throws UnableToRegisterRightException {
        try {
            HashSet<Right> augmentedImpliedByRights = new HashSet<Right>(impliedByRights);
            augmentedImpliedByRights.addAll(DEFAULT_IMPLIED_BY_RIGHTS);
            Right newRight = new Right(rightDescription, augmentedImpliedByRights);
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)this.xwikiBridge.getMainWikiReference()));
            return newRight;
        }
        catch (Throwable e) {
            Right right = Right.toRight(rightDescription.getName());
            if (right != Right.ILLEGAL && right.like(rightDescription)) {
                return right;
            }
            throw new UnableToRegisterRightException(rightDescription, e);
        }
    }

    private SecurityAccess getAccess(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        for (SecurityReference ref = entity; ref != null; ref = ref.getParentSecurityReference()) {
            if (Right.getEnabledRights(ref.getSecurityType()).isEmpty()) continue;
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry == null) {
                SecurityAccess access = this.securityCacheLoader.load(user, entity).getAccess();
                this.logger.debug("1. Loaded a new entry for user {} on {} into cache: [{}]", new Object[]{user, entity, access});
                return access;
            }
            if (entry.isEmpty()) continue;
            SecurityAccessEntry accessEntry = this.securityCache.get(user, ref);
            if (accessEntry == null) {
                SecurityAccess access = this.securityCacheLoader.load(user, entity).getAccess();
                this.logger.debug("2. Loaded a new entry for user {} on {} into cache: [{}]", new Object[]{user, entity, access});
                return access;
            }
            SecurityAccess access = accessEntry.getAccess();
            this.logger.debug("3. Got entry for user {} on {} from cache: [{}]", new Object[]{user, entity, access});
            return access;
        }
        SecurityAccess access = this.securityCacheLoader.load(user, entity).getAccess();
        this.logger.debug("4. Loaded a new default entry for user {} on {} into cache: [{}]", new Object[]{user, entity, access});
        return access;
    }

    private void logAccess(RuleState access, DocumentReference user, EntityReference entity, Right right, String info, boolean debugLevel) {
        if (debugLevel && this.logger.isDebugEnabled() || !debugLevel && this.logger.isInfoEnabled()) {
            String userName = user != null ? (String)this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]) : "Public";
            String docName = entity != null ? (String)this.entityReferenceSerializer.serialize(entity, new Object[0]) : "Public";
            String rightName = right != null ? right.getName() : "no right";
            String accessName = access == RuleState.ALLOW ? "granted" : "denied";
            String message = "[{}] access has been {} for user [{}] on [{}]: {}";
            if (debugLevel) {
                this.logger.debug(message, new Object[]{rightName, accessName, userName, docName, info});
            } else {
                this.logger.info(message, new Object[]{rightName, accessName, userName, docName, info});
            }
        }
    }

    protected void logDeny(DocumentReference user, EntityReference entity, Right right, String info) {
        this.logAccess(RuleState.DENY, user, entity, right, info, false);
    }
}

