/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityAccess;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityAccessEntry;
import org.xwiki.security.authorization.internal.XWikiSecurityAccess;
import org.xwiki.security.internal.EntityBridge;
import org.xwiki.security.internal.XWikiBridge;

abstract class AbstractAuthorizationSettler
implements AuthorizationSettler {
    private static RightSet initialAllowTie;
    private static RightSet initialNoOverride;
    private static int initialPolicySize;
    @Inject
    private EntityBridge entityBridge;
    @Inject
    private XWikiBridge wikiBridge;

    AbstractAuthorizationSettler() {
    }

    private boolean isMainWikiUser(UserSecurityReference user) {
        SecurityReference wikiReference = user;
        while (wikiReference.getType() != EntityType.WIKI) {
            wikiReference = wikiReference.getParentSecurityReference();
        }
        return wikiReference.getParentSecurityReference() == null;
    }

    private boolean isInitialImportState(UserSecurityReference user, Collection<GroupSecurityReference> groups, Deque<SecurityRuleEntry> ruleEntries) {
        if (ruleEntries.getLast().getRules().size() == 0 && this.isMainWikiUser(user)) {
            int level = 0;
            Iterator<SecurityRuleEntry> r = ruleEntries.descendingIterator();
            while (r.hasNext()) {
                SecurityRuleEntry e = r.next();
                if (level == 1) {
                    return e.getReference().getType() != EntityType.WIKI;
                }
                ++level;
            }
            return true;
        }
        return false;
    }

    @Override
    public SecurityAccessEntry settle(UserSecurityReference user, Collection<GroupSecurityReference> groups, Deque<SecurityRuleEntry> ruleEntries) {
        SecurityReference reference = ruleEntries.getFirst().getReference();
        if (this.isInitialImportState(user, groups, ruleEntries)) {
            return new InternalSecurityAccessEntry(user, reference, XWikiSecurityAccess.getInitialImportAccess());
        }
        XWikiSecurityAccess access = new XWikiSecurityAccess();
        Policies policies = new Policies();
        for (SecurityRuleEntry entry : ruleEntries) {
            access = this.merge(this.settle(user, groups, entry, policies), access, entry.getReference(), policies);
        }
        return new InternalSecurityAccessEntry(user, reference, this.postProcess(user, reference, access));
    }

    protected XWikiSecurityAccess postProcess(UserSecurityReference user, SecurityReference reference, XWikiSecurityAccess access) {
        if (this.wikiBridge.isWikiOwner(user, new WikiReference(reference.extractReference(EntityType.WIKI)))) {
            access.allow(Right.ADMIN);
            Set<Right> impliedRights = Right.ADMIN.getImpliedRights();
            for (Right enabledRight : Right.getEnabledRights(EntityType.WIKI)) {
                if (!impliedRights.contains(enabledRight)) continue;
                access.allow(enabledRight);
            }
        } else if (Right.getEnabledRights(reference.getSecurityType()).contains(Right.DELETE) && this.entityBridge.isDocumentCreator(user, reference)) {
            access.allow(Right.DELETE);
        }
        for (Right right : Right.values()) {
            if (access.get(right) != RuleState.UNDETERMINED) continue;
            if (!user.getOriginalReference().getWikiReference().equals((Object)reference.extractReference(EntityType.WIKI))) {
                access.deny(right);
                continue;
            }
            access.set(right, right.getDefaultState());
        }
        return access;
    }

    protected abstract XWikiSecurityAccess settle(UserSecurityReference var1, Collection<GroupSecurityReference> var2, SecurityRuleEntry var3, Policies var4);

    protected XWikiSecurityAccess merge(SecurityAccess currentAccess, XWikiSecurityAccess access, SecurityReference reference, Policies policies) {
        for (Right right : Right.getEnabledRights(reference.getSecurityType())) {
            if (currentAccess.get(right) == RuleState.UNDETERMINED) continue;
            if (access.get(right) == RuleState.UNDETERMINED) {
                access.set(right, currentAccess.get(right));
                continue;
            }
            if (currentAccess.get(right) != RuleState.ALLOW || policies.getInheritanceOverridePolicy(right)) continue;
            access.allow(right);
        }
        return access;
    }

    protected final class Policies {
        private Set<Right> allowTie;
        private Set<Right> noOverride;

        Policies() {
            try {
                if (initialAllowTie == null || Right.size() != initialPolicySize) {
                    initialPolicySize = Right.size();
                    this.allowTie = new RightSet();
                    this.noOverride = new RightSet();
                    for (Right right : Right.values()) {
                        this.set(right, right);
                    }
                    initialAllowTie = ((RightSet)this.allowTie).clone();
                    initialNoOverride = ((RightSet)this.noOverride).clone();
                } else {
                    this.allowTie = initialAllowTie.clone();
                    this.noOverride = initialNoOverride.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        public void set(Right impliedRight, Right originalRight) {
            if (originalRight.getTieResolutionPolicy() == RuleState.ALLOW) {
                this.allowTie.add(impliedRight);
            }
            if (!originalRight.getInheritanceOverridePolicy()) {
                this.noOverride.add(impliedRight);
            }
        }

        public RuleState getTieResolutionPolicy(Right right) {
            return this.allowTie.contains(right) ? RuleState.ALLOW : RuleState.DENY;
        }

        public boolean getInheritanceOverridePolicy(Right right) {
            return !this.noOverride.contains(right);
        }
    }

    private final class InternalSecurityAccessEntry
    extends AbstractSecurityAccessEntry {
        private final UserSecurityReference userReference;
        private final SecurityReference reference;
        private final SecurityAccess access;

        InternalSecurityAccessEntry(UserSecurityReference user, SecurityReference reference, SecurityAccess access) {
            this.userReference = user;
            this.reference = reference;
            this.access = access;
        }

        @Override
        public UserSecurityReference getUserReference() {
            return this.userReference;
        }

        @Override
        public SecurityAccess getAccess() {
            return this.access;
        }

        @Override
        public SecurityReference getReference() {
            return this.reference;
        }
    }
}

