/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security;

import java.util.Deque;
import java.util.LinkedList;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

public class SecurityReference
extends EntityReference {
    public static final EntityType FARM = null;
    private static final long serialVersionUID = 1L;
    protected SecurityReference mainWikiReference;
    private EntityReference originalReference;

    SecurityReference(EntityReference reference) {
        super(reference);
        this.originalReference = reference;
        this.mainWikiReference = this;
    }

    SecurityReference(EntityReference reference, SecurityReference mainWiki) {
        super((EntityReference)(reference != null ? reference : mainWiki));
        this.originalReference = reference != null ? reference : mainWiki.getOriginalReference();
        this.mainWikiReference = mainWiki;
    }

    public SecurityReference getParentSecurityReference() {
        EntityReference parent = this.getParent();
        if (parent == null && this.getType() == EntityType.WIKI && !this.equals((Object)this.mainWikiReference)) {
            return this.mainWikiReference;
        }
        return parent != null && !(parent instanceof SecurityReference) ? new SecurityReference(parent, this.mainWikiReference) : (SecurityReference)parent;
    }

    public Deque<SecurityReference> getReversedSecurityReferenceChain() {
        LinkedList<SecurityReference> referenceList = new LinkedList<SecurityReference>();
        SecurityReference reference = this;
        do {
            referenceList.push(reference);
        } while ((reference = reference.getParentSecurityReference()) != null);
        return referenceList;
    }

    public EntityType getSecurityType() {
        EntityType type = this.getType();
        if (type != EntityType.WIKI || !this.equals((Object)this.mainWikiReference)) {
            return type;
        }
        return FARM;
    }

    public SecurityReference getWikiReference() {
        SecurityReference result;
        for (result = this; result != null && result.getType() != EntityType.WIKI; result = result.getParentSecurityReference()) {
        }
        return result;
    }

    public EntityReference getOriginalReference() {
        return this.originalReference;
    }

    public WikiReference getOriginalWikiReference() {
        return this.getType() == EntityType.WIKI ? (this.originalReference instanceof WikiReference ? (WikiReference)this.originalReference : new WikiReference(this.originalReference)) : null;
    }

    public SpaceReference getOriginalSpaceReference() {
        return this.getType() == EntityType.SPACE ? (this.originalReference instanceof SpaceReference ? (SpaceReference)this.originalReference : new SpaceReference(this.originalReference)) : null;
    }

    public DocumentReference getOriginalDocumentReference() {
        return this.getType() == EntityType.DOCUMENT ? (this.originalReference instanceof DocumentReference ? (DocumentReference)this.originalReference : new DocumentReference(this.originalReference)) : null;
    }
}

