/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.Right;

public class AuthorizationException
extends Exception {
    static final String NULL_ENTITY = "Main Wiki";
    static final String NULL_USER = "Public";
    private static final long serialVersionUID = 1L;

    public AuthorizationException(String message) {
        super(message);
    }

    public AuthorizationException(String message, Throwable cause) {
        super(message, cause);
    }

    public AuthorizationException(DocumentReference userReference, EntityReference entityReference) {
        this(userReference, entityReference, null, null);
    }

    public AuthorizationException(DocumentReference userReference, EntityReference entityReference, String message) {
        this(null, userReference, entityReference, message, null);
    }

    public AuthorizationException(Right right, DocumentReference userReference, EntityReference entityReference, String message) {
        this(right, userReference, entityReference, message, null);
    }

    public AuthorizationException(DocumentReference userReference, EntityReference entityReference, String message, Throwable cause) {
        this(null, userReference, entityReference, message, cause);
    }

    public AuthorizationException(Right right, DocumentReference userReference, EntityReference entityReference, String message, Throwable cause) {
        super(String.format("%s when checking %s access to [%s] for user [%s]", message, right == null ? "" : "[" + right.getName() + "]", entityReference == null ? NULL_ENTITY : entityReference, userReference == null ? NULL_USER : userReference), cause);
    }

    public AuthorizationException(EntityReference entityReference, String message, Throwable cause) {
        super(String.format("%s when checking access to [%s]", message, entityReference == null ? NULL_ENTITY : entityReference), cause);
    }

    public AuthorizationException(DocumentReference userReference, EntityReference entityReference, Throwable cause) {
        this(userReference, entityReference, null, cause);
    }
}

