/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.cache.SecurityCacheRulesInvalidator;
import org.xwiki.security.authorization.cache.internal.DefaultSecurityShadowEntry;
import org.xwiki.security.authorization.cache.internal.SecurityCache;
import org.xwiki.security.internal.UserBridge;

@Component
@Singleton
public class DefaultSecurityCacheLoader
implements SecurityCacheLoader {
    private static final int MAX_RETRIES = 5;
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityCacheRulesInvalidator rulesInvalidator;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private UserBridge userBridge;
    @Inject
    private Provider<AuthorizationSettler> authorizationSettlerProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityAccessEntry load(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        int retries = 0;
        while (true) {
            this.rulesInvalidator.suspend();
            try {
                ++retries;
                SecurityAccessEntry securityAccessEntry = this.loadRequiredEntries(user, entity);
                return securityAccessEntry;
            }
            catch (ParentEntryEvictedException e) {
                if (retries >= 5) break;
                this.logger.debug("The parent entry was evicted. Have tried {} times.  Trying again...", (Object)retries);
                continue;
            }
            catch (ConflictingInsertionException e) {
                if (retries >= 5) break;
                this.logger.debug("There were conflicting insertions. Have tried {} times.  Retrying...", (Object)retries);
                continue;
            }
            finally {
                this.rulesInvalidator.resume();
                continue;
            }
            break;
        }
        String message = String.format("Failed to load the cache in %d attempts.  Giving up.", retries);
        this.logger.error(message);
        throw new AuthorizationException(user.getOriginalDocumentReference(), entity.getOriginalReference(), message);
    }

    private SecurityAccessEntry loadRequiredEntries(UserSecurityReference user, SecurityReference entity) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        if (entity == null) {
            return ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, this.loadUserEntry(user, user.getWikiReference(), null), null);
        }
        Deque<SecurityRuleEntry> ruleEntries = this.getRules(entity);
        return this.loadAccessEntries(user, entity, ruleEntries);
    }

    private SecurityAccessEntry loadAccessEntries(UserSecurityReference user, SecurityReference entity, Deque<SecurityRuleEntry> ruleEntries) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        SecurityReference entityWiki;
        SecurityReference userWiki = user.getWikiReference();
        SecurityReference securityReference = entityWiki = user.isGlobal() ? entity.getWikiReference() : null;
        if (entityWiki != null && userWiki.equals((Object)entityWiki)) {
            entityWiki = null;
        }
        Collection<GroupSecurityReference> groups = this.loadUserEntry(user, userWiki, entityWiki);
        SecurityAccessEntry accessEntry = ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, groups, ruleEntries);
        this.securityCache.add(accessEntry, entityWiki);
        return accessEntry;
    }

    private Collection<GroupSecurityReference> loadUserEntry(UserSecurityReference user, SecurityReference userWiki, SecurityReference entityWiki) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = this.securityCache.getGroupsFor(user, entityWiki);
        if (groups != null) {
            return groups;
        }
        groups = new HashSet<GroupSecurityReference>();
        if (user.getOriginalReference() == null) {
            if (this.securityCache.get(user) == null) {
                this.getRules(user);
            }
            if (entityWiki != null) {
                this.securityCache.add(new DefaultSecurityShadowEntry(user, entityWiki), null);
            }
            return groups;
        }
        if (entityWiki != null) {
            Collection<GroupSecurityReference> globalGroups = this.securityCache.getGroupsFor(user, null);
            if (globalGroups == null) {
                globalGroups = new HashSet<GroupSecurityReference>();
                this.loadUserEntry(user, userWiki, null, globalGroups);
            }
            groups.addAll(globalGroups);
            for (GroupSecurityReference group : globalGroups) {
                HashSet<GroupSecurityReference> localGroups = new HashSet<GroupSecurityReference>();
                this.loadUserEntry(group, userWiki, entityWiki, localGroups);
                groups.addAll(localGroups);
            }
            HashSet<GroupSecurityReference> localGroups = new HashSet<GroupSecurityReference>();
            this.loadUserEntry(user, userWiki, entityWiki, localGroups);
            groups.addAll(localGroups);
        } else {
            HashSet<GroupSecurityReference> localGroups = new HashSet<GroupSecurityReference>();
            this.loadUserEntry(user, userWiki, null, localGroups);
            groups.addAll(localGroups);
        }
        return groups;
    }

    private void loadUserEntry(UserSecurityReference user, SecurityReference userWiki, SecurityReference entityWiki, Collection<GroupSecurityReference> allGroups) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = entityWiki != null ? this.userBridge.getAllGroupsFor(user, entityWiki.getOriginalWikiReference()) : this.userBridge.getAllGroupsFor(user, userWiki.getOriginalWikiReference());
        ArrayList<GroupSecurityReference> userGroups = new ArrayList<GroupSecurityReference>();
        for (GroupSecurityReference group : groups) {
            if (!allGroups.add(group)) continue;
            Collection<GroupSecurityReference> groupsOfGroup = this.securityCache.getGroupsFor(group, entityWiki);
            if (groupsOfGroup == null) {
                this.loadUserEntry(group, entityWiki != null ? entityWiki : userWiki, null, allGroups);
            } else {
                allGroups.addAll(groupsOfGroup);
            }
            userGroups.add(group);
        }
        if (entityWiki != null) {
            this.securityCache.add(new DefaultSecurityShadowEntry(user, entityWiki), userGroups);
        } else {
            this.loadUserEntry(user, userGroups);
        }
    }

    private void loadUserEntry(UserSecurityReference user, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Deque<SecurityReference> chain = user.getReversedSecurityReferenceChain();
        chain.removeLast();
        for (SecurityReference ref : chain) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry != null) continue;
            entry = this.securityEntryReader.read(ref);
            this.securityCache.add(entry);
        }
        SecurityRuleEntry entry = this.securityEntryReader.read(user);
        this.securityCache.add(entry, groups);
    }

    private Deque<SecurityRuleEntry> getRules(SecurityReference entity) throws AuthorizationException, ParentEntryEvictedException, ConflictingInsertionException {
        LinkedList<SecurityRuleEntry> rules = new LinkedList<SecurityRuleEntry>();
        for (SecurityReference ref : entity.getReversedSecurityReferenceChain()) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry == null) {
                entry = this.securityEntryReader.read(ref);
                this.securityCache.add(entry);
            }
            rules.push(entry);
        }
        return rules;
    }

    private SecurityReference getWikiReference(SecurityReference entity) {
        SecurityReference result;
        for (result = entity; result != null && result.getType() != EntityType.WIKI; result = result.getParentSecurityReference()) {
        }
        return result;
    }
}

