/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.cache.SecurityCacheRulesInvalidator;
import org.xwiki.security.authorization.cache.internal.DefaultSecurityShadowEntry;
import org.xwiki.security.authorization.cache.internal.SecurityCache;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;
import org.xwiki.security.internal.UserBridge;

@Component
@Singleton
public class DefaultSecurityCacheLoader
implements SecurityCacheLoader {
    private static final int MAX_RETRIES = 5;
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityCacheRulesInvalidator rulesInvalidator;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private UserBridge userBridge;
    @Inject
    private Provider<AuthorizationSettler> authorizationSettlerProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityAccessEntry load(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        Exception lastException;
        int retries = 0;
        while (true) {
            this.rulesInvalidator.suspend();
            try {
                ++retries;
                SecurityAccessEntry securityAccessEntry = this.loadRequiredEntries(user, entity);
                return securityAccessEntry;
            }
            catch (ParentEntryEvictedException e) {
                lastException = e;
                if (retries >= 5) break;
                this.logger.debug("The parent entry was evicted. Have tried {} times.  Trying again...", (Object)retries);
                continue;
            }
            catch (ConflictingInsertionException e) {
                lastException = e;
                if (retries >= 5) break;
                this.logger.debug("There were conflicting insertions. Have tried {} times.  Retrying...", (Object)retries);
                continue;
            }
            finally {
                this.rulesInvalidator.resume();
                continue;
            }
            break;
        }
        String message = String.format("Failed to load the cache in %d attempts. Giving up.", retries);
        this.logger.error(message);
        throw new AuthorizationException(user.getOriginalDocumentReference(), entity.getOriginalReference(), message, lastException);
    }

    private SecurityAccessEntry loadRequiredEntries(UserSecurityReference user, SecurityReference entity) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        if (entity == null) {
            return ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, this.loadUserEntry(user, user.getWikiReference(), null), null);
        }
        Deque<SecurityRuleEntry> ruleEntries = this.getRules(entity);
        return this.loadAccessEntries(user, entity, ruleEntries);
    }

    private SecurityAccessEntry loadAccessEntries(UserSecurityReference user, SecurityReference entity, Deque<SecurityRuleEntry> ruleEntries) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        SecurityReference entityWiki;
        SecurityReference userWiki = user.getWikiReference();
        SecurityReference securityReference = entityWiki = user.isGlobal() ? entity.getWikiReference() : null;
        if (entityWiki != null && userWiki.equals((Object)entityWiki)) {
            entityWiki = null;
        }
        Collection<GroupSecurityReference> groups = this.loadUserEntry(user, userWiki, entityWiki);
        SecurityAccessEntry accessEntry = ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, groups, ruleEntries);
        this.securityCache.add(accessEntry, entityWiki);
        return accessEntry;
    }

    private Collection<GroupSecurityReference> loadUserEntry(UserSecurityReference user, SecurityReference userWiki, SecurityReference entityWiki) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = this.securityCache.getGroupsFor(user, entityWiki);
        if (groups != null) {
            return groups;
        }
        groups = new HashSet<GroupSecurityReference>();
        if (user.getOriginalReference() == null) {
            if (this.securityCache.get(user) == null) {
                this.getRules(user);
            }
            if (entityWiki != null) {
                this.securityCache.add(new DefaultSecurityShadowEntry(user, entityWiki), null);
            }
            return groups;
        }
        if (entityWiki != null) {
            Collection<GroupSecurityReference> immediateGroups;
            Collection<GroupSecurityReference> globalGroups = this.securityCache.getGroupsFor(user, null);
            if (globalGroups == null) {
                globalGroups = new HashSet<GroupSecurityReference>();
                immediateGroups = this.loadUserGroups(user, userWiki, globalGroups);
                this.loadUserEntry(user, immediateGroups);
            } else {
                immediateGroups = this.securityCache.getImmediateGroupsFor(user);
            }
            groups.addAll(globalGroups);
            for (GroupSecurityReference group : globalGroups) {
                Collection<GroupSecurityReference> localGroups = this.securityCache.getGroupsFor(group, entityWiki);
                if (localGroups == null) {
                    localGroups = new HashSet<GroupSecurityReference>();
                    this.securityCache.add(new DefaultSecurityShadowEntry(group, entityWiki), this.loadUserGroups(group, entityWiki, localGroups));
                }
                groups.addAll(localGroups);
            }
            HashSet<GroupSecurityReference> localGroups = new HashSet<GroupSecurityReference>();
            immediateGroups.addAll(this.loadUserGroups(user, entityWiki, localGroups));
            this.securityCache.add(new DefaultSecurityShadowEntry(user, entityWiki), immediateGroups);
            groups.addAll(localGroups);
        } else {
            HashSet<GroupSecurityReference> localGroups = new HashSet<GroupSecurityReference>();
            this.loadUserEntry(user, this.loadUserGroups(user, userWiki, localGroups));
            groups.addAll(localGroups);
        }
        return groups;
    }

    private Collection<GroupSecurityReference> loadUserGroups(UserSecurityReference user, SecurityReference wiki, Collection<GroupSecurityReference> allGroups) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        return this.loadUserGroups(user, wiki, allGroups, new ArrayDeque<GroupSecurityReference>());
    }

    private Collection<GroupSecurityReference> loadUserGroups(UserSecurityReference user, SecurityReference wiki, Collection<GroupSecurityReference> allGroups, Deque<GroupSecurityReference> branchGroups) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = this.userBridge.getAllGroupsFor(user, wiki.getOriginalWikiReference());
        ArrayList<GroupSecurityReference> immediateGroup = new ArrayList<GroupSecurityReference>();
        for (GroupSecurityReference group : groups) {
            if (branchGroups.contains((Object)group)) continue;
            Collection<GroupSecurityReference> groupsOfGroup = this.securityCache.getGroupsFor(group, null);
            if (groupsOfGroup == null) {
                immediateGroup.add(group);
                branchGroups.push(group);
                this.loadUserEntry(group, this.loadUserGroups(group, wiki, allGroups, branchGroups));
                branchGroups.pop();
                continue;
            }
            boolean recursionFound = false;
            for (GroupSecurityReference existingGroup : groupsOfGroup) {
                if (!branchGroups.contains((Object)existingGroup)) continue;
                recursionFound = true;
                break;
            }
            if (recursionFound) continue;
            immediateGroup.add(group);
            allGroups.addAll(groupsOfGroup);
        }
        allGroups.addAll(immediateGroup);
        return immediateGroup;
    }

    private void loadUserEntry(UserSecurityReference user, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Deque<SecurityReference> chain = user.getReversedSecurityReferenceChain();
        chain.removeLast();
        for (SecurityReference ref : chain) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry != null) continue;
            entry = this.securityEntryReader.read(ref);
            this.securityCache.add(entry);
        }
        SecurityRuleEntry entry = this.securityEntryReader.read(user);
        this.securityCache.add(entry, groups);
    }

    private Deque<SecurityRuleEntry> getRules(SecurityReference entity) throws AuthorizationException, ParentEntryEvictedException, ConflictingInsertionException {
        LinkedList<SecurityRuleEntry> rules = new LinkedList<SecurityRuleEntry>();
        ArrayList<SecurityRuleEntry> emptyRuleEntryTail = new ArrayList<SecurityRuleEntry>();
        for (SecurityReference ref : entity.getReversedSecurityReferenceChain()) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry == null) {
                if (Right.getEnabledRights(ref.getType()).isEmpty()) {
                    entry = new EmptySecurityRuleEntry(ref);
                    emptyRuleEntryTail.add(entry);
                } else {
                    entry = this.securityEntryReader.read(ref);
                    if (!emptyRuleEntryTail.isEmpty()) {
                        for (SecurityRuleEntry emptyRuleEntry : emptyRuleEntryTail) {
                            this.securityCache.add(emptyRuleEntry);
                        }
                        emptyRuleEntryTail.clear();
                    }
                    this.securityCache.add(entry);
                }
            }
            rules.push(entry);
        }
        return rules;
    }

    private final class EmptySecurityRuleEntry
    extends AbstractSecurityRuleEntry {
        private final SecurityReference reference;

        private EmptySecurityRuleEntry(SecurityReference reference) {
            this.reference = reference;
        }

        @Override
        public SecurityReference getReference() {
            return this.reference;
        }

        @Override
        public Collection<SecurityRule> getRules() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

