/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.stability.Unstable;

@Unstable
public enum AuthenticationAction {
    RESET_PASSWORD("reset"),
    FORGOT_USERNAME("forgot");

    private String requestParameter;

    private AuthenticationAction(String requestParameter) {
        this.requestParameter = requestParameter;
    }

    public String getRequestParameter() {
        return this.requestParameter;
    }

    public static AuthenticationAction getFromRequestParameter(String parameter) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            throw new IllegalArgumentException("The parameter needs to be provided.");
        }
        for (AuthenticationAction value : AuthenticationAction.values()) {
            if (!value.requestParameter.equals(parameter.toLowerCase())) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Cannot find an AuthenticationAction for parameter [%s]", parameter));
    }
}

