/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.security.authentication.AuthenticationConfiguration;

@Component
@Singleton
public class DefaultAuthenticationConfiguration
implements AuthenticationConfiguration {
    @Inject
    @Named(value="authentication")
    private ConfigurationSource configuration;

    public int getMaxAuthorizedAttempts() {
        return (Integer)this.configuration.getProperty("maxAuthorizedAttempts", (Object)3);
    }

    public int getTimeWindow() {
        return (Integer)this.configuration.getProperty("timeWindowAttempts", (Object)300);
    }

    public String[] getFailureStrategies() {
        String strategies = (String)this.configuration.getProperty("failureStrategy", (Object)"");
        if (!StringUtils.isEmpty((CharSequence)strategies)) {
            return strategies.split(",");
        }
        return new String[0];
    }

    public boolean isAuthenticationSecurityEnabled() {
        return (Boolean)this.configuration.getProperty("isAuthenticationSecurityEnabled", (Object)true);
    }
}

