/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal.resource;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.security.authentication.AuthenticationAction;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="authenticate")
@Singleton
public class AuthenticationResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    public AuthenticationResourceReference resolve(ExtendedURL representation, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        List segments = representation.getSegments();
        if (segments.size() == 1) {
            String actionName = (String)segments.get(0);
            try {
                AuthenticationAction authenticationAction = AuthenticationAction.getFromRequestParameter((String)actionName);
                AuthenticationResourceReference result = new AuthenticationResourceReference(authenticationAction);
                this.copyParameters(representation, (ResourceReference)result);
                return result;
            }
            catch (IllegalArgumentException e) {
                throw new CreateResourceReferenceException(String.format("Cannot find an authentication action for name [%s]", actionName));
            }
        }
        throw new CreateResourceReferenceException(String.format("Invalid Authentication URL format: [%s]", representation.toString()));
    }
}

