/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public class XWikiCachingRightService
implements XWikiRightService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiCachingRightService.class);
    private static final String DELETE_ACTION = "delete";
    private static final String LOGIN_ACTION = "login";
    private static final ActionMap ACTION_MAP = new ActionMap();
    private DocumentReferenceResolver<String> documentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING);
    private DocumentReferenceResolver<String> userAndGroupReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING, (String)"user");
    private final AuthorizationManager authorizationManager = (AuthorizationManager)Utils.getComponent(AuthorizationManager.class);

    public static Right actionToRight(String action) {
        Right right = (Right)ACTION_MAP.get(action);
        if (right == null) {
            return Right.ILLEGAL;
        }
        return right;
    }

    private DocumentReference resolveUserName(String username, WikiReference wikiReference) {
        return this.userAndGroupReferenceResolver.resolve((Object)username, new Object[]{wikiReference});
    }

    private DocumentReference resolveDocumentName(String docname, WikiReference wikiReference) {
        return this.documentReferenceResolver.resolve((Object)docname, new Object[]{wikiReference});
    }

    private void showLogin(XWikiContext context) {
        try {
            if (context.getRequest() != null && !LOGIN_ACTION.equals(context.getAction()) && !context.getWiki().Param("xwiki.hidelogin", "false").equalsIgnoreCase("true")) {
                context.getWiki().getAuthService().showLogin(context);
            }
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to show login page.", (Throwable)e);
        }
    }

    private DocumentReference getCurrentUser(XWikiContext context) {
        DocumentReference contextUserReference = context.getUserReference();
        DocumentReference userReference = contextUserReference;
        if (userReference == null && context.getMode() != 2) {
            try {
                XWikiUser user = context.getWiki().checkAuth(context);
                if (user != null) {
                    userReference = this.resolveUserName(user.getUser(), new WikiReference(context.getDatabase()));
                }
            }
            catch (XWikiException e) {
                LOGGER.error("Caught exception while authenticating user.", (Throwable)e);
            }
        }
        if (userReference != null && "XWikiGuest".equals(userReference.getName())) {
            userReference = null;
        }
        if (!(userReference == contextUserReference || userReference != null && userReference.equals((Object)contextUserReference))) {
            context.setUserReference(userReference);
        }
        return userReference;
    }

    private Boolean checkNeedsAuthValue(String value) {
        if (value != null && !value.equals("")) {
            if (value.toLowerCase().equals("yes")) {
                return true;
            }
            try {
                if (Integer.parseInt(value) > 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse the authenticate_* preference value [{}]", (Object)value);
            }
        }
        return null;
    }

    private boolean needsAuth(Right right, XWikiContext context) {
        String prefName = "authenticate_" + right.getName();
        String value = context.getWiki().getXWikiPreference(prefName, "", context);
        Boolean result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        value = context.getWiki().getSpacePreference(prefName, "", context).toLowerCase();
        result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        return false;
    }

    public boolean checkAccess(String action, XWikiDocument doc, XWikiContext context) throws XWikiException {
        Right right = XWikiCachingRightService.actionToRight(action);
        DocumentReference entityReference = doc.getDocumentReference();
        LOGGER.debug("checkAccess for action [{}] on entity [{}].", (Object)right, (Object)entityReference);
        DocumentReference userReference = this.getCurrentUser(context);
        if (userReference == null && this.needsAuth(right, context)) {
            this.showLogin(context);
            return false;
        }
        if (this.authorizationManager.hasAccess(right, userReference, (EntityReference)entityReference)) {
            return true;
        }
        if (userReference == null && !DELETE_ACTION.equals(action) && !LOGIN_ACTION.equals(action)) {
            LOGGER.debug("Redirecting unauthenticated user to login, since it have been denied [{}] on [{}].", (Object)right, (Object)entityReference);
            this.showLogin(context);
        }
        return false;
    }

    public boolean hasAccessLevel(String right, String username, String docname, XWikiContext context) throws XWikiException {
        WikiReference wikiReference = new WikiReference(context.getDatabase());
        DocumentReference document = this.resolveDocumentName(docname, wikiReference);
        LOGGER.debug("hasAccessLevel() resolved document named [{}] into reference [{}]", (Object)docname, (Object)document);
        DocumentReference user = this.resolveUserName(username, wikiReference);
        if ("XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return this.authorizationManager.hasAccess(Right.toRight((String)right), user, (EntityReference)document);
    }

    public boolean hasProgrammingRights(XWikiContext context) {
        if (context.hasDroppedPermissions()) {
            return false;
        }
        XWikiDocument sdoc = (XWikiDocument)context.get((Object)"sdoc");
        return this.hasProgrammingRights(sdoc != null ? sdoc : context.getDoc(), context);
    }

    public boolean hasProgrammingRights(XWikiDocument doc, XWikiContext context) {
        WikiReference wiki;
        DocumentReference user;
        if (doc != null) {
            user = doc.getContentAuthorReference();
            wiki = doc.getDocumentReference().getWikiReference();
        } else {
            user = context.getUserReference();
            wiki = new WikiReference(context.getDatabase());
        }
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return this.authorizationManager.hasAccess(Right.PROGRAM, user, (EntityReference)wiki);
    }

    public boolean hasAdminRights(XWikiContext context) {
        XWikiDocument doc = context.getDoc();
        if (doc == null) {
            return this.hasWikiAdminRights(context);
        }
        DocumentReference user = context.getUserReference();
        DocumentReference document = doc.getDocumentReference();
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return this.authorizationManager.hasAccess(Right.ADMIN, user, (EntityReference)document);
    }

    public boolean hasWikiAdminRights(XWikiContext context) {
        DocumentReference user = context.getUserReference();
        WikiReference wiki = new WikiReference(context.getDatabase());
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return this.authorizationManager.hasAccess(Right.ADMIN, user, (EntityReference)wiki);
    }

    public List<String> listAllLevels(XWikiContext context) throws XWikiException {
        return Right.getAllRightsAsString();
    }

    static {
        ACTION_MAP.putAction(LOGIN_ACTION, Right.LOGIN).putAction("imagecaptcha", Right.LOGIN).putAction("view", Right.VIEW).putAction(DELETE_ACTION, Right.DELETE).putAction("distribution", Right.VIEW).putAction("admin", Right.ADMIN).putAction("programing", Right.PROGRAM).putAction("edit", Right.EDIT).putAction("register", Right.REGISTER).putAction("logout", Right.LOGIN).putAction("loginerror", Right.LOGIN).putAction("loginsubmit", Right.LOGIN).putAction("viewrev", Right.VIEW).putAction("viewattachrev", Right.VIEW).putAction("get", Right.VIEW).putAction("downloadrev", Right.VIEW).putAction("plain", Right.VIEW).putAction("raw", Right.VIEW).putAction("attach", Right.VIEW).putAction("charting", Right.VIEW).putAction("skin", Right.VIEW).putAction("download", Right.VIEW).putAction("dot", Right.VIEW).putAction("svg", Right.VIEW).putAction("pdf", Right.VIEW).putAction("undelete", Right.EDIT).putAction("reset", Right.DELETE).putAction("commentadd", Right.COMMENT).putAction("redirect", Right.VIEW).putAction("export", Right.VIEW).putAction("import", Right.ADMIN).putAction("jsx", Right.VIEW).putAction("ssx", Right.VIEW).putAction("tex", Right.VIEW).putAction("unknown", Right.VIEW).putAction("save", Right.EDIT).putAction("preview", Right.EDIT).putAction("lock", Right.EDIT).putAction("cancel", Right.EDIT).putAction("delattachment", Right.EDIT).putAction("inline", Right.EDIT).putAction("propadd", Right.EDIT).putAction("propupdate", Right.EDIT).putAction("propdelete", Right.EDIT).putAction("propdisable", Right.EDIT).putAction("propenable", Right.EDIT).putAction("objectadd", Right.EDIT).putAction("objectremove", Right.EDIT).putAction("objectsync", Right.EDIT).putAction("rollback", Right.EDIT).putAction("upload", Right.EDIT).putAction("create", Right.EDIT).putAction("deleteversions", Right.ADMIN).putAction("deletespace", Right.ADMIN).putAction("temp", Right.VIEW);
    }

    private static class ActionMap
    extends HashMap<String, Right> {
        private static final long serialVersionUID = 1L;

        private ActionMap() {
        }

        public ActionMap putAction(String action, Right right) {
            this.put(action, right);
            return this;
        }
    }
}

