/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.GroupsClass;
import com.xpn.xwiki.objects.classes.LevelsClass;
import com.xpn.xwiki.objects.classes.UsersClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.text.XWikiToStringStyle;

public final class XWikiSecurityRule
implements SecurityRule {
    private final Set<DocumentReference> users = new HashSet<DocumentReference>();
    private final Set<DocumentReference> groups = new HashSet<DocumentReference>();
    private final RightSet rights = new RightSet();
    private final RuleState state;

    protected XWikiSecurityRule(Set<Right> rights, RuleState state, Collection<DocumentReference> users, Collection<DocumentReference> groups) {
        if (users != null) {
            this.users.addAll(users);
        }
        if (groups != null) {
            this.groups.addAll(groups);
        }
        this.rights.addAll(rights);
        this.state = state;
    }

    private XWikiSecurityRule(BaseObject obj, DocumentReferenceResolver<String> resolver, WikiReference wikiReference, boolean disableEditRight) {
        this.state = obj.getIntValue("allow") == 1 ? RuleState.ALLOW : RuleState.DENY;
        for (String level : LevelsClass.getListFromString((String)obj.getStringValue("levels"))) {
            Right right = Right.toRight((String)level);
            if (right == Right.ILLEGAL || disableEditRight && right == Right.EDIT) continue;
            this.rights.add(right);
        }
        if (this.rights.size() > 0) {
            DocumentReference ref;
            for (String user : UsersClass.getListFromString((String)obj.getStringValue("users"))) {
                ref = resolver.resolve((Object)user, new Object[]{wikiReference});
                if ("XWikiGuest".equals(ref.getName())) {
                    ref = null;
                }
                this.users.add(ref);
            }
            for (String group : GroupsClass.getListFromString((String)obj.getStringValue("groups"))) {
                ref = resolver.resolve((Object)group, new Object[]{wikiReference});
                this.groups.add(ref);
            }
        }
    }

    static SecurityRule createNewRule(BaseObject obj, DocumentReferenceResolver<String> resolver, WikiReference wikiReference, boolean disableEditRight) throws IllegalArgumentException {
        XWikiSecurityRule rule = new XWikiSecurityRule(obj, resolver, wikiReference, disableEditRight);
        if (rule.rights.size() == 0) {
            throw new IllegalArgumentException("No rights to build this rule.");
        }
        if (rule.users.size() == 0 && rule.groups.size() == 0) {
            throw new IllegalArgumentException("No user/group to build this rule.");
        }
        return rule;
    }

    public boolean match(Right right) {
        return this.rights.contains((Object)right);
    }

    public boolean match(GroupSecurityReference group) {
        return this.groups.contains(group.getOriginalReference());
    }

    public boolean match(UserSecurityReference user) {
        return this.users.contains(user.getOriginalReference());
    }

    public RuleState getState() {
        return this.state;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        XWikiSecurityRule other = (XWikiSecurityRule)object;
        return this.state == other.state && this.rights.equals((Object)other.rights) && ((Object)this.users).equals(other.users) && ((Object)this.groups).equals(other.groups);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.state).append((Object)this.rights).append(this.users).append(this.groups).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, (ToStringStyle)new XWikiToStringStyle());
        return builder.append("State", (Object)this.state).append("Rights", (Object)this.rights).append("Users", this.users).append("Groups", this.groups).toString();
    }
}

