/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="security.authorization")
@Singleton
public class SecurityAuthorizationScriptService
implements ScriptService {
    public static final String ID = "authorization";
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public void checkAccess(Right right) throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(right);
    }

    public boolean hasAccess(Right right) {
        return this.contextualAuthorizationManager.hasAccess(right);
    }

    public void checkAccess(Right right, EntityReference entityReference) throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(right, entityReference);
    }

    public boolean hasAccess(Right right, EntityReference entityReference) {
        return this.contextualAuthorizationManager.hasAccess(right, entityReference);
    }

    public void checkAccess(Right right, DocumentReference userReference, EntityReference entityReference) throws AccessDeniedException {
        this.authorizationManager.checkAccess(right, userReference, entityReference);
    }

    public boolean hasAccess(Right right, DocumentReference userReference, EntityReference entityReference) {
        return this.authorizationManager.hasAccess(right, userReference, entityReference);
    }

    @Unstable
    public boolean isRightRegistered(String rightName) {
        return Right.toRight((String)rightName) != Right.ILLEGAL;
    }
}

