/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.sheet.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.sheet.SheetManager;
import org.xwiki.sheet.internal.ModelBridge;

@Component
@Named(value="sheet")
@Singleton
public class SheetDocumentDisplayer
implements DocumentDisplayer {
    @Inject
    private Logger logger;
    @Inject
    private DocumentDisplayer documentDisplayer;
    @Inject
    private SheetManager sheetManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private ModelContext modelContext;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        XDOM xdom = null;
        if (!this.isSheetExpected(document, parameters)) return xdom != null ? xdom : this.documentDisplayer.display((Object)document, (Object)parameters);
        Map<String, Object> backupObjects = null;
        EntityReference currentWikiReference = null;
        try {
            if (!this.modelBridge.isCurrentDocument(document)) {
                backupObjects = this.modelBridge.pushDocumentInContext(document);
                currentWikiReference = this.modelContext.getCurrentEntityReference();
                this.modelContext.setCurrentEntityReference((EntityReference)document.getDocumentReference().getWikiReference());
            }
            xdom = this.maybeDisplayWithSheet(document, parameters);
            if (backupObjects == null) return xdom != null ? xdom : this.documentDisplayer.display((Object)document, (Object)parameters);
        }
        catch (Throwable throwable) {
            if (backupObjects == null) throw throwable;
            this.documentAccessBridge.popDocumentFromContext(backupObjects);
            this.modelContext.setCurrentEntityReference(currentWikiReference);
            throw throwable;
        }
        this.documentAccessBridge.popDocumentFromContext(backupObjects);
        this.modelContext.setCurrentEntityReference(currentWikiReference);
        return xdom != null ? xdom : this.documentDisplayer.display((Object)document, (Object)parameters);
    }

    private boolean isSheetExpected(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        return parameters.isContentTransformed() && (parameters.isExecutionContextIsolated() || document.getDocumentReference().equals((Object)this.documentAccessBridge.getCurrentDocumentReference())) && this.isNewSheetSystem(document);
    }

    private boolean isNewSheetSystem(DocumentModelBridge document) {
        return this.sheetManager.isSheetForced() || "edit".equals(this.modelBridge.getDefaultEditMode(document));
    }

    private XDOM maybeDisplayWithSheet(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        for (DocumentReference sheetReference : this.getSheetReferences(document)) {
            if (document.getDocumentReference().equals((Object)sheetReference)) break;
            if (!this.documentAccessBridge.isDocumentViewable(sheetReference)) continue;
            try {
                return this.applySheet(document, sheetReference, parameters);
            }
            catch (Exception e) {
                String sheetStringReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)sheetReference, new Object[0]);
                this.logger.warn("Failed to apply sheet [{}].", (Object)sheetStringReference, (Object)e);
            }
        }
        return null;
    }

    private List<DocumentReference> getSheetReferences(DocumentModelBridge document) {
        return this.sheetManager.getSheets(this.modelBridge.getDefaultTranslation(document), this.modelBridge.getCurrentAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XDOM applySheet(DocumentModelBridge document, DocumentReference sheetReference, DocumentDisplayerParameters parameters) throws Exception {
        DocumentModelBridge sheet = this.documentAccessBridge.getTranslatedDocumentInstance(sheetReference);
        if (parameters.isTitleDisplayed() && StringUtils.isEmpty((CharSequence)sheet.getTitle())) {
            return null;
        }
        DocumentModelBridge originalSecurityDoc = this.modelBridge.setSecurityDocument(sheet);
        try {
            XDOM xDOM = this.display(document, sheet, parameters);
            return xDOM;
        }
        finally {
            this.modelBridge.setSecurityDocument(originalSecurityDoc);
        }
    }

    private XDOM display(DocumentModelBridge document, DocumentModelBridge sheet, DocumentDisplayerParameters parameters) {
        DocumentDisplayerParameters sheetDisplayParameters = parameters.clone();
        sheetDisplayParameters.setExecutionContextIsolated(false);
        return this.documentDisplayer.display((Object)sheet, (Object)sheetDisplayParameters);
    }
}

