/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.skinx.internal.async;

import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Contains a skin extension to use.
 * 
 * @version $Id: c9889318a84f37768e84be651fe29739195fc6b1 $
 * @since 10.10RC1
 */
public class SkinExtensionInfo
{
    private String type;

    private String resource;

    private Map<String, Object> parameters;

    /**
     * @param type the type of skin extension
     * @param resource the resource name
     * @param parameters the parameters
     */
    public SkinExtensionInfo(String type, String resource, Map<String, Object> parameters)
    {
        this.type = type;
        this.resource = resource;
        this.parameters = parameters;
    }

    /**
     * @return the type of skin extension
     */
    public String getType()
    {
        return this.type;
    }

    /**
     * @return the resource name
     */
    public String getResource()
    {
        return this.resource;
    }

    /**
     * @return the parameters
     */
    public Map<String, Object> getParameters()
    {
        return this.parameters;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (!(obj instanceof SkinExtensionInfo)) {
            return false;
        }

        SkinExtensionInfo otherExtensionInfo = (SkinExtensionInfo) obj;

        EqualsBuilder builder = new EqualsBuilder();

        builder.append(this.resource, otherExtensionInfo.resource);
        builder.append(this.type, otherExtensionInfo.type);
        builder.append(this.parameters, otherExtensionInfo.parameters);

        return builder.isEquals();
    }

    @Override
    public int hashCode()
    {
        HashCodeBuilder builder = new HashCodeBuilder();

        builder.append(this.resource);
        builder.append(this.type);
        builder.append(this.parameters);

        return builder.toHashCode();
    }
}
