/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.skinx.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.ExportURLFactoryActionHandler;
import com.xpn.xwiki.web.ExportURLFactoryContext;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxDocumentSource;
import com.xpn.xwiki.web.sx.SxResourceSource;
import com.xpn.xwiki.web.sx.SxSource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractSxExportURLFactoryActionHandler
implements ExportURLFactoryActionHandler {
    private static final String JAR_RESOURCE_REQUEST_PARAMETER = "resource";
    private static final char URL_PATH_SEPARATOR = '/';
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    protected abstract String getSxPrefix();

    protected abstract String getFileSuffix();

    public abstract Extension getExtensionType();

    public URL createURL(String web, String name, String queryString, String anchor, String wikiId, XWikiContext context, ExportURLFactoryContext factoryContext) throws Exception {
        DocumentReference sxDocumentReference = new DocumentReference(wikiId, web, name);
        this.authorizationManager.checkAccess(Right.VIEW, (EntityReference)sxDocumentReference);
        XWikiDocument sxDocument = context.getWiki().getDocument(sxDocumentReference, context);
        HashMap backup = new HashMap();
        XWikiDocument.backupContext(backup, (XWikiContext)context);
        try {
            sxDocument.setAsContextDoc(context);
            URL uRL = this.processSx(web, name, queryString, context, factoryContext);
            return uRL;
        }
        finally {
            XWikiDocument.restoreContext(backup, (XWikiContext)context);
        }
    }

    private URL processSx(String web, String name, String queryString, XWikiContext context, ExportURLFactoryContext factoryContext) throws Exception {
        SxSource sxSource = null;
        List params = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
        for (NameValuePair param : params) {
            if (!param.getName().equals(JAR_RESOURCE_REQUEST_PARAMETER)) continue;
            sxSource = new SxResourceSource(param.getValue());
            break;
        }
        if (sxSource == null) {
            sxSource = new SxDocumentSource(context, this.getExtensionType());
        }
        String content = this.getContent(sxSource, factoryContext);
        String targetPath = String.format("%s/%s/%s", this.getSxPrefix(), web, name);
        File targetDirectory = new File(factoryContext.getExportDir(), targetPath);
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        File targetLocation = File.createTempFile(this.getSxPrefix(), "." + this.getFileSuffix(), targetDirectory);
        FileUtils.writeStringToFile((File)targetLocation, (String)content);
        StringBuffer path = new StringBuffer("file://");
        path.append(this.getSxPrefix());
        path.append('/');
        path.append(this.encodeURLPart(web));
        path.append('/');
        path.append(this.encodeURLPart(name));
        path.append('/');
        path.append(this.encodeURLPart(targetLocation.getName()));
        return new URL(path.toString());
    }

    protected String getContent(SxSource sxSource, ExportURLFactoryContext factoryContext) {
        return sxSource.getContent();
    }

    private String encodeURLPart(String part) throws IOException {
        return URLEncoder.encode(part, "UTF-8");
    }
}

