/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.internal.cache.rendering.CachedItem;
import com.xpn.xwiki.internal.cache.rendering.RenderingCacheAware;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.skinx.SkinExtensionPluginApi;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSkinExtensionPlugin
extends XWikiDefaultPlugin
implements RenderingCacheAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSkinExtensionPlugin.class);
    protected final String contextKey = ((Object)((Object)this)).getClass().getCanonicalName();
    protected final String parametersContextKey = String.valueOf(((Object)((Object)this)).getClass().getCanonicalName()) + "_parameters";

    public AbstractSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public abstract String getLink(String var1, XWikiContext var2);

    public abstract Set<String> getAlwaysUsedExtensions(XWikiContext var1);

    public abstract boolean hasPageExtensions(XWikiContext var1);

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SkinExtensionPluginApi((AbstractSkinExtensionPlugin)plugin, context);
    }

    public void use(String resource, XWikiContext context) {
        LOGGER.debug("Using [{}] as [{}] extension", (Object)resource, (Object)this.getName());
        this.getPulledResources(context).add(resource);
        this.getParametersMap(context).remove(resource);
    }

    public void use(String resource, Map<String, Object> parameters, XWikiContext context) {
        this.use(resource, context);
        this.getParametersMap(context).put(resource, parameters);
    }

    protected Set<String> getPulledResources(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Set)context.get((Object)this.contextKey);
    }

    protected Map<String, Map<String, Object>> getParametersMap(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Map)context.get((Object)this.parametersContextKey);
    }

    protected void initializeRequestListIfNeeded(XWikiContext context) {
        if (!context.containsKey((Object)this.contextKey)) {
            context.put((Object)this.contextKey, new LinkedHashSet());
        }
        if (!context.containsKey((Object)this.parametersContextKey)) {
            context.put((Object)this.parametersContextKey, new HashMap());
        }
    }

    public String getImportString(XWikiContext context) {
        StringBuilder result = new StringBuilder();
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.addAll(this.getAlwaysUsedExtensions(context));
        extensions.addAll(this.getPulledResources(context));
        if (this.hasPageExtensions(context)) {
            extensions.add(context.getDoc().getFullName());
        }
        for (String documentName : extensions) {
            result.append(this.getLink(documentName, context));
        }
        return result.toString();
    }

    protected Map<String, Object> getParametersForResource(String resource, XWikiContext context) {
        Map<String, Object> result = this.getParametersMap(context).get(resource);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    protected Object getParameter(String parameterName, String resource, XWikiContext context) {
        return this.getParametersForResource(resource, context).get(parameterName);
    }

    protected String parametersAsQueryString(String resource, XWikiContext context) {
        Map<String, Object> parameters = this.getParametersForResource(resource, context);
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if ("forceSkinAction".equals(parameter.getKey())) continue;
            query.append("&amp;");
            query.append(this.sanitize(parameter.getKey()));
            query.append("=");
            query.append(this.sanitize(parameter.getValue().toString()));
        }
        if ("false".equals(context.getRequest().getParameter("minify"))) {
            query.append("&amp;minify=false");
        }
        return query.toString();
    }

    protected String sanitize(String value) {
        String result = value;
        try {
            result = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return result;
    }

    public String endParsing(String content, XWikiContext context) {
        String hook = "<!-- " + ((Object)((Object)this)).getClass().getCanonicalName() + " -->";
        String result = content.replaceFirst(hook, this.getImportString(context));
        return result;
    }

    public CachedItem.UsedExtension getCacheResources(XWikiContext context) {
        return new CachedItem.UsedExtension(this.getPulledResources(context), new HashMap<String, Map<String, Object>>(this.getParametersMap(context)));
    }

    public void restoreCacheResources(XWikiContext context, CachedItem.UsedExtension extension) {
        this.getPulledResources(context).addAll(extension.resources);
        this.getParametersMap(context).putAll(extension.parameters);
    }
}

