/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.browser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.xwiki.test.ui.XWikiWrappingDriver;
import org.xwiki.test.ui.browser.IgnoreBrowser;
import org.xwiki.test.ui.browser.IgnoreBrowsers;

public class BrowserMethodRule
implements MethodRule {
    private String currentBrowserName;
    private String currentBrowserVersion;

    public BrowserMethodRule(WebDriver driver) {
        WebDriver nativeDriver = driver;
        if (driver instanceof XWikiWrappingDriver) {
            nativeDriver = ((XWikiWrappingDriver)driver).getWrappedDriver();
        }
        Capabilities capability = ((RemoteWebDriver)nativeDriver).getCapabilities();
        this.currentBrowserName = capability.getBrowserName();
        this.currentBrowserVersion = capability.getVersion();
    }

    public Statement apply(final Statement statement, final FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                IgnoreBrowsers ignoreBrowsers;
                ArrayList<IgnoreBrowser> ignoredBrowsersList = new ArrayList<IgnoreBrowser>();
                IgnoreBrowser ignoreBrowser = (IgnoreBrowser)method.getAnnotation(IgnoreBrowser.class);
                if (ignoreBrowser != null) {
                    ignoredBrowsersList.add(ignoreBrowser);
                }
                if ((ignoreBrowsers = (IgnoreBrowsers)method.getAnnotation(IgnoreBrowsers.class)) != null) {
                    ignoredBrowsersList.addAll(Arrays.asList(ignoreBrowsers.value()));
                }
                for (IgnoreBrowser ignoredBrowser : ignoredBrowsersList) {
                    Pattern browserNamePattern = Pattern.compile(ignoredBrowser.value());
                    Pattern browserVersionPattern = Pattern.compile(ignoredBrowser.version());
                    if (!browserNamePattern.matcher(BrowserMethodRule.this.currentBrowserName).matches() || !ignoredBrowser.version().isEmpty() && !browserVersionPattern.matcher(BrowserMethodRule.this.currentBrowserVersion).matches()) continue;
                    throw new AssumptionViolatedException(ignoredBrowser.reason());
                }
                statement.evaluate();
            }
        };
    }
}

