/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.pagefactory.ByChained;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;

public class CreatePagePage
extends ViewPage {
    @FindBy(id="space")
    private WebElement spaceTextField;
    @FindBy(id="page")
    private WebElement pageTextField;

    public static CreatePagePage gotoPage() {
        CreatePagePage.getUtil().gotoPage("Main", "WebHome", "create");
        return new CreatePagePage();
    }

    public String getSpace() {
        return this.spaceTextField.getAttribute("value");
    }

    public void setSpace(String space) {
        this.spaceTextField.clear();
        this.spaceTextField.sendKeys(new CharSequence[]{space});
    }

    public String getPage() {
        return this.pageTextField.getAttribute("value");
    }

    public void setPage(String page) {
        this.pageTextField.clear();
        this.pageTextField.sendKeys(new CharSequence[]{page});
    }

    public int getAvailableTemplateSize() {
        return this.getDriver().findElements(By.name((String)"templateprovider")).size() - 1;
    }

    public List<String> getAvailableTemplates() {
        ArrayList<String> availableTemplates = new ArrayList<String>();
        List<WebElement> templateInputs = this.getDriver().findElements(By.name((String)"templateprovider"));
        for (WebElement input : templateInputs) {
            if (input.getAttribute("value").length() <= 0) continue;
            availableTemplates.add(input.getAttribute("value"));
        }
        return availableTemplates;
    }

    public void setTemplate(String template) {
        List<WebElement> templates = this.getDriver().findElements(By.name((String)"templateprovider"));
        for (WebElement templateInput : templates) {
            if (!templateInput.getAttribute("value").equals(template)) continue;
            templateInput.click();
            return;
        }
        throw new RuntimeException("Failed to find template [" + template + "]");
    }

    public void clickCreate() {
        this.pageTextField.submit();
    }

    public WYSIWYGEditPage createPage(String spaceValue, String pageValue) {
        this.setSpace(spaceValue);
        this.setPage(pageValue);
        this.clickCreate();
        return new WYSIWYGEditPage();
    }

    public WYSIWYGEditPage createPageFromTemplate(String spaceValue, String pageValue, String templateValue) {
        this.setSpace(spaceValue);
        this.setPage(pageValue);
        this.setTemplate(templateValue);
        this.clickCreate();
        return new WYSIWYGEditPage();
    }

    public void waitForErrorMessage() {
        this.waitUntilElementIsVisible(By.className((String)"errormessage"));
    }

    public void waitForFieldErrorMessage() {
        this.waitUntilElementIsVisible((By)new ByChained(new By[]{By.className((String)"LV_invalid")}));
    }
}

