/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.test.ui;

import org.junit.Before;

/**
 * Helper class to be extended by tests not requiring any user to be logged in (XWikiGuest is then the current user).
 *
 * @version $Id: 15df823145d5c04d403cf8f6bc6f52a1f033aec1 $
 * @since 4.2M3
 */
public abstract class AbstractGuestTest extends AbstractTest
{
    @Before
    public void setUp() throws Exception
    {
        // Log out the user (and it does token recaching automatically)
        getUtil().setSession(null);
    }
}
