/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDebugger
extends TestWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDebugger.class);
    private static final String SCREENSHOT_DIR = System.getProperty("screenshotDirectory");
    private final WebDriver driver;

    public TestDebugger(WebDriver driver) {
        this.driver = driver;
    }

    protected void starting(Description description) {
        LOGGER.info("{} started", (Object)this.getTestName(description));
    }

    protected void succeeded(Description description) {
        LOGGER.info("{} passed", (Object)this.getTestName(description));
    }

    protected void failed(Throwable e, Description description) {
        LOGGER.info("{} failed", (Object)this.getTestName(description));
        this.takeScreenshot(description);
        LOGGER.info("Current page URL is [{}]", (Object)this.driver.getCurrentUrl());
        LOGGER.info("Current page source is [{}]", (Object)this.driver.getPageSource());
    }

    private String getTestName(Description description) {
        return description.getTestClass().getSimpleName() + "-" + description.getMethodName();
    }

    private void takeScreenshot(Description description) {
        this.takeScreenshot(this.getTestName(description));
    }

    public void takeScreenshot(String testName) {
        if (!(this.driver instanceof TakesScreenshot)) {
            LOGGER.warn("The WebDriver that is currently used doesn't support taking screenshots.");
            return;
        }
        try {
            File screenshotFile;
            File sourceFile = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
            if (SCREENSHOT_DIR != null) {
                File screenshotDir = new File(SCREENSHOT_DIR);
                screenshotDir.mkdirs();
                screenshotFile = new File(screenshotDir, testName + ".png");
            } else {
                screenshotFile = new File(new File(System.getProperty("java.io.tmpdir")), testName + ".png");
            }
            FileUtils.copyFile((File)sourceFile, (File)screenshotFile);
            LOGGER.info("Screenshot for failing test [{}] saved at [{}].", (Object)testName, (Object)screenshotFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to take screenshot for failing test [{}].", (Object)testName, (Object)e);
        }
    }
}

