/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.CommentForm;
import org.xwiki.test.ui.po.ConfirmationModal;
import org.xwiki.test.ui.po.ViewPage;

public class CommentsTab
extends ViewPage {
    @FindBy(xpath="//fieldset[@id='commentform']/label/span")
    private WebElement commentAuthor;
    @FindBy(id="XWiki.XWikiComments_author")
    private WebElement anonymousCommentAuthor;
    private ConfirmationModal confirmDelete;
    private List<WebElement> commentsList;

    public String getCurrentAuthor() {
        return this.commentAuthor.getAttribute("value");
    }

    public boolean isCommentFormShown() {
        WebElement commentForm = this.getDriver().findElement(By.xpath((String)"//form[@id='AddComment']/fieldset[@id='commentform']"));
        return commentForm.isDisplayed();
    }

    public void setAnonymousCommentAuthor(String author) {
        this.anonymousCommentAuthor.clear();
        this.anonymousCommentAuthor.sendKeys(new CharSequence[]{author});
    }

    public int getCommentID(String content) {
        this.commentsList = CommentsTab.getUtil().findElementsWithoutWaiting(this.getDriver(), By.className((String)"xwikicomment"));
        for (int i = 0; i < this.commentsList.size(); ++i) {
            if (!this.commentsList.get(i).findElement(By.className((String)"commentcontent")).getText().equals(content)) continue;
            return Integer.parseInt(this.commentsList.get(i).getAttribute("id").substring("xwikicomment_".length()));
        }
        return -1;
    }

    public CommentForm getAddCommentForm() {
        return new CommentForm(By.id((String)"AddComment"));
    }

    public int postComment(String content, boolean wait) {
        CommentForm addCommentForm = this.getAddCommentForm();
        addCommentForm.getContentField().sendKeys(new CharSequence[]{content});
        addCommentForm.clickSubmit(wait);
        return this.getCommentID(content);
    }

    public int postCommentAsGuest(String content, String author, boolean wait) {
        CommentForm addCommentForm = this.getAddCommentForm();
        addCommentForm.getContentField().sendKeys(new CharSequence[]{content});
        this.setAnonymousCommentAuthor(author);
        addCommentForm.clickSubmit(wait);
        return this.getCommentID(content);
    }

    public void deleteCommentByID(int id) {
        this.getDriver().findElement(By.xpath((String)("//div[@id='xwikicomment_" + id + "']//a[@class='delete']"))).click();
        this.confirmDelete = new ConfirmationModal();
        this.confirmDelete.clickOk();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Comment deleted']"));
        this.getDriver().findElement(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Comment deleted']")).click();
    }

    public CommentForm replyToCommentByID(int id) {
        CommentsTab.getUtil().findElementWithoutWaiting(this.getDriver(), By.xpath((String)("//div[@id='xwikicomment_" + id + "']//a[@class='commentreply']"))).click();
        return this.getAddCommentForm();
    }

    public void replyToCommentByID(int id, String replyContent) {
        CommentForm replyCommentForm = this.replyToCommentByID(id);
        replyCommentForm.getContentField().sendKeys(new CharSequence[]{replyContent});
        replyCommentForm.clickSubmit();
    }

    public CommentForm editCommentByID(int id) {
        CommentsTab.getUtil().findElementWithoutWaiting(this.getDriver(), By.xpath((String)("//div[@id='xwikicomment_" + id + "']//a[@class='edit']"))).click();
        this.waitUntilElementIsVisible(By.id((String)("XWiki.XWikiComments_" + id + "_comment")));
        return new CommentForm(By.className((String)"edit-xcomment"));
    }

    public void editCommentByID(int id, String content) {
        CommentForm editCommentForm = this.editCommentByID(id);
        editCommentForm.getContentField().clear();
        editCommentForm.getContentField().sendKeys(new CharSequence[]{content});
        editCommentForm.clickSubmit();
    }

    public String getCommentAuthorByID(int id) {
        return CommentsTab.getUtil().findElementWithoutWaiting(this.getDriver(), By.xpath((String)("//div[@id='xwikicomment_" + id + "']//span[@class='commentauthor']"))).getText();
    }

    public String getCommentContentByID(int id) {
        return CommentsTab.getUtil().findElementWithoutWaiting(this.getDriver(), By.xpath((String)("//div[@id='xwikicomment_" + id + "']//div[@class='commentcontent']"))).getText();
    }

    public boolean hasEditButtonForCommentByID(int commentId) {
        return CommentsTab.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)("//div[@id='xwikicomment_" + commentId + "']//a[@class='edit']"))).size() > 0;
    }
}

