/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class TableElement
extends BaseElement {
    private final WebElement table;
    private int empty = -1;
    private int numberOfColumns = -1;
    private int numberOfRows = -1;

    public TableElement(WebElement table) {
        if (!table.getTagName().toLowerCase().equals("table")) {
            throw new WebDriverException("You can only create a TableElement using a <table> web element,you passed a <" + table.getTagName() + "> element");
        }
        this.table = !table.findElements(By.tagName((String)"tbody")).isEmpty() ? (WebElement)table.findElements(By.tagName((String)"tbody")).get(0) : table;
    }

    public boolean isEmpty() {
        if (this.empty == -1) {
            for (WebElement row : this.table.findElements(By.tagName((String)"tr"))) {
                if (row.findElements(By.tagName((String)"td")).isEmpty()) continue;
                this.empty = 0;
                return false;
            }
            this.empty = 1;
        }
        return this.empty == 1;
    }

    public int numberOfColumns() {
        if (this.numberOfRows() == 0) {
            return 0;
        }
        if (this.numberOfColumns == -1) {
            this.numberOfColumns = this.getRow(0).size();
        }
        return this.numberOfColumns;
    }

    public int numberOfRows() {
        if (this.numberOfRows == -1) {
            this.numberOfRows = this.table.findElements(By.tagName((String)"tr")).size();
        }
        return this.numberOfRows;
    }

    public List<WebElement> getColumn(String firstEntry) {
        return this.getColumn(this.getColumnNumber(firstEntry));
    }

    public int getColumnNumber(String firstEntry) {
        if (this.numberOfRows() == 0) {
            return -1;
        }
        List<WebElement> headers = this.getRow(0);
        for (WebElement header : headers) {
            if (!header.getText().equals(firstEntry)) continue;
            return headers.indexOf(header);
        }
        return -1;
    }

    public List<WebElement> getColumn(int columnNumber) {
        if (this.numberOfRows() == 0 || this.numberOfColumns() < columnNumber || columnNumber < 0) {
            return null;
        }
        return this.table.findElements(By.xpath((String)("//tr/th[" + (columnNumber + 1) + "]" + " | //tr/td[" + (columnNumber + 1) + "]")));
    }

    public List<WebElement> getRow(String firstEntry) {
        return this.getRow(this.getRowNumber(firstEntry));
    }

    public int getRowNumber(String firstEntry) {
        if (this.numberOfColumns() == 0) {
            return -1;
        }
        List<WebElement> headers = this.getColumn(0);
        for (WebElement header : headers) {
            if (!header.getText().equals(firstEntry)) continue;
            return headers.indexOf(header);
        }
        return -1;
    }

    public List<WebElement> getRow(int rowNumber) {
        if (this.numberOfRows() <= rowNumber || rowNumber < 0) {
            return null;
        }
        return this.table.findElements(By.xpath((String)("//tr[" + (rowNumber + 1) + "]/th" + " | //tr[" + (rowNumber + 1) + "]/td")));
    }
}

