/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor.wysiwyg;

import org.openqa.selenium.By;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.editor.wysiwyg.RichTextAreaElement;

public class EditorElement
extends BaseElement {
    private final String fieldId;

    public EditorElement(String fieldId) {
        this.fieldId = fieldId;
    }

    public RichTextAreaElement getRichTextArea() {
        return new RichTextAreaElement(this.getContainer().findElement(By.className((String)"gwt-RichTextArea")));
    }

    public EditorElement waitToLoad() {
        EditorElement.getUtil().waitUntilCondition(new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                try {
                    EditorElement.this.getContainer(driver).findElement(By.xpath((String)"//div[@class = 'gwt-TabBarItem gwt-TabBarItem-selected']/div[. = 'Source']"));
                    WebElement sourceTextArea = EditorElement.this.getContainer(driver).findElement(By.className((String)"xPlainTextEditor"));
                    return sourceTextArea.isEnabled() ? sourceTextArea : null;
                }
                catch (NotFoundException sourceNotFound) {
                    WebElement richTextEditor = EditorElement.this.getContainer(driver).findElement(By.className((String)"xRichTextEditor"));
                    try {
                        richTextEditor.findElement(By.className((String)"loading"));
                        return null;
                    }
                    catch (NotFoundException loadingNotFound) {
                        return richTextEditor;
                    }
                }
            }
        });
        return this;
    }

    private WebElement getContainer(WebDriver driver) {
        return driver.findElement(By.xpath((String)("//div[starts-with(@id, '" + this.fieldId + "_container')]")));
    }

    protected WebElement getContainer() {
        return this.getContainer(this.getDriver());
    }
}

