/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import java.io.IOException;
import org.jboss.arquillian.phantom.resolver.ResolvingPhantomJSDriverService;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverFactory {
    public WebDriver createWebDriver(String browserName) {
        InternetExplorerDriver driver;
        if (browserName.startsWith("*firefox")) {
            FirefoxProfile profile = new FirefoxProfile();
            profile.setEnableNativeEvents(true);
            profile.setPreference("app.update.auto", false);
            profile.setPreference("app.update.enabled", false);
            profile.setPreference("app.update.silent", false);
            driver = new FirefoxDriver(profile);
            driver.get("data:text/plain;charset=utf-8,XWiki");
            driver.switchTo().activeElement().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "/"})});
        } else if (browserName.startsWith("*iexplore")) {
            driver = new InternetExplorerDriver();
        } else if (browserName.startsWith("*chrome")) {
            driver = new ChromeDriver();
        } else if (browserName.startsWith("*phantomjs")) {
            DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
            capabilities.setCapability("handlesAlerts", true);
            try {
                driver = new PhantomJSDriver(ResolvingPhantomJSDriverService.createDefaultService(), (Capabilities)capabilities);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unsupported browser name [" + browserName + "]");
        }
        driver.manage().window().maximize();
        return driver;
    }
}

