/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import com.google.code.tempusfugit.concurrency.IntermittentTestRunner;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.xwiki.test.ui.PersistentTestContext;
import org.xwiki.test.ui.TestDebugger;
import org.xwiki.test.ui.TestUtils;
import org.xwiki.test.ui.browser.BrowserTestRule;
import org.xwiki.test.ui.po.BaseElement;

@RunWith(value=IntermittentTestRunner.class)
public abstract class AbstractTest {
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public BrowserTestRule browserRule = new BrowserTestRule(AbstractTest.getDriver());
    @Rule
    public TestDebugger testDebugger = new TestDebugger(AbstractTest.getDriver());
    protected static PersistentTestContext context;

    public static void setContext(PersistentTestContext context) {
        AbstractTest.context = context;
        BaseElement.setContext(context);
        TestUtils.setContext(context);
        AbstractTest.getUtil().recacheSecretToken();
    }

    @BeforeClass
    public static void init() throws Exception {
        if (context == null) {
            AbstractTest.setContext(new PersistentTestContext());
        }
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (context != null) {
            context.shutdown();
        }
    }

    protected String getTestMethodName() {
        return this.testName.getMethodName();
    }

    protected String getTestClassName() {
        return this.getClass().getSimpleName();
    }

    protected static WebDriver getDriver() {
        return context.getDriver();
    }

    protected static TestUtils getUtil() {
        return context.getUtil();
    }
}

