/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;

public class EntityTreeElement
extends BaseElement {
    @FindBy(xpath="//div[@class = 'listGrid']/following-sibling::input")
    private WebElement input;

    public EntityTreeElement waitForSpace(String spaceName) {
        return this.waitForSpace(spaceName, false);
    }

    public EntityTreeElement waitForSpace(String spaceName, boolean selected) {
        return this.waitForNodeWithHintAndLabel("Located in xwiki \u00bb " + spaceName, spaceName, selected);
    }

    public boolean hasSpace(String spaceName) {
        return this.hasNodeWithHintAndLabel("Located in xwiki \u00bb " + spaceName, spaceName);
    }

    public EntityTreeElement waitForPage(String spaceName, String pageName) {
        return this.waitForPage(spaceName, pageName, false);
    }

    public EntityTreeElement waitForPage(String spaceName, String pageName, String pageTitle) {
        return this.waitForPage(spaceName, pageName, pageTitle, false);
    }

    public EntityTreeElement waitForPage(String spaceName, String pageName, boolean selected) {
        return this.waitForPage(spaceName, pageName, pageName, selected);
    }

    public EntityTreeElement waitForPage(String spaceName, String pageName, String pageTitle, boolean selected) {
        return this.waitForNodeWithHintAndLabel(String.format("Located in xwiki \u00bb %s \u00bb %s", spaceName, pageName), pageTitle, selected);
    }

    public boolean hasPage(String spaceName, String pageName) {
        return this.hasPage(spaceName, pageName, pageName);
    }

    public boolean hasPage(String spaceName, String pageName, String pageTitle) {
        return this.hasNodeWithHintAndLabel(String.format("Located in xwiki \u00bb %s \u00bb %s", spaceName, pageName), pageTitle);
    }

    public EntityTreeElement waitForAttachment(String spaceName, String pageName, String fileName) {
        return this.waitForAttachment(spaceName, pageName, fileName, false);
    }

    public EntityTreeElement waitForAttachment(String spaceName, String pageName, String fileName, boolean selected) {
        return this.waitForNodeWithHintAndLabel(String.format("Attached to xwiki \u00bb %s \u00bb %s", spaceName, pageName), fileName, selected);
    }

    public boolean hasAttachment(String spaceName, String pageName, String fileName) {
        return this.hasNodeWithHintAndLabel(String.format("Attached to xwiki \u00bb %s \u00bb %s", spaceName, pageName), fileName);
    }

    public void lookupEntity(String entityReference) {
        this.input.clear();
        this.input.sendKeys(new CharSequence[]{entityReference});
    }

    private EntityTreeElement waitForNodeWithHintAndLabel(String hint, String label, boolean selected) {
        String className = selected ? "treeCellSelected" : "treeCell";
        String xpath = String.format("//td[contains(@class, '%s')]//*[@title = '%s' and . = '%s']", className, hint, label);
        this.waitUntilElementIsVisible(By.xpath((String)xpath));
        return this;
    }

    private boolean hasNodeWithHintAndLabel(String hint, String label) {
        String format = "//td[starts-with(@class, 'treeCell')]//*[@title = '%s' and . = '%s']";
        return EntityTreeElement.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)String.format(format, hint, label))).size() == 1;
    }
}

