/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;

public class Classpath {
    private final Vector<File> _elements = new Vector();

    public Classpath() {
    }

    public Classpath(String initial) {
        this.addClasspath(initial);
    }

    public File[] getElements() {
        return this._elements.toArray(new File[this._elements.size()]);
    }

    public int count() {
        return this._elements.size();
    }

    public boolean addComponent(String component) {
        if (component != null && component.length() > 0) {
            try {
                File key;
                File f = new File(component);
                if (f.exists() && !this._elements.contains(key = f.getCanonicalFile())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean addComponent(File component) {
        if (component != null) {
            try {
                File key;
                if (component.exists() && !this._elements.contains(key = component.getCanonicalFile())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean addClasspath(String s) {
        boolean added = false;
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, File.pathSeparator);
            while (t.hasMoreTokens()) {
                added |= this.addComponent(t.nextToken());
            }
        }
        return added;
    }

    public void dump(PrintStream out) {
        int i = 0;
        for (File element : this._elements) {
            out.printf("%2d: %s\n", i++, element.getAbsolutePath());
        }
    }

    public String toString() {
        StringBuffer cp = new StringBuffer(1024);
        int cnt = this._elements.size();
        if (cnt >= 1) {
            cp.append(this._elements.elementAt(0).getPath());
        }
        for (int i = 1; i < cnt; ++i) {
            cp.append(File.pathSeparatorChar);
            cp.append(this._elements.elementAt(i).getPath());
        }
        return cp.toString();
    }

    public ClassLoader getClassLoader() {
        int cnt = this._elements.size();
        URL[] urls = new URL[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                urls[i] = this._elements.elementAt(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = Classpath.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return new Loader(urls, parent);
    }

    public void overlay(Classpath cpOther) {
        for (File otherElement : cpOther._elements) {
            if (this._elements.contains(otherElement)) continue;
            this._elements.add(otherElement);
        }
    }

    public boolean isEmpty() {
        return this._elements == null || this._elements.isEmpty();
    }

    private static class Loader
    extends URLClassLoader {
        Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public String toString() {
            return "startJarLoader@" + Long.toHexString(this.hashCode());
        }
    }
}

