/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.backup;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.packaging.Package;
import com.xpn.xwiki.plugin.packaging.PackageException;
import com.xpn.xwiki.store.XWikiCacheStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.tool.backup.AbstractPackager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.xwiki.model.reference.DocumentReference;

public class Importer
extends AbstractPackager {
    public void importDocuments(File sourceDirectory, String databaseName, File hibernateConfig) throws Exception {
        this.importDocuments(sourceDirectory, databaseName, hibernateConfig, null);
    }

    public void importDocuments(File sourceDirectory, String databaseName, File hibernateConfig, String importUser) throws Exception {
        XWikiContext context = this.createXWikiContext(databaseName, hibernateConfig);
        Package pack = new Package();
        pack.setWithVersions(false);
        try {
            pack.readFromDir(sourceDirectory, context);
        }
        catch (IOException e) {
            throw new PackageException(1, "Failed to import documents from [" + sourceDirectory + "]", (Throwable)e);
        }
        this.installWithUser(importUser, pack, context);
        this.shutdownHSQLDB(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importXAR(File file, String importUser, XWikiContext context) throws XWikiException, IOException {
        Package pack = new Package();
        pack.setWithVersions(false);
        FileInputStream fis = new FileInputStream(file);
        try {
            pack.Import((InputStream)fis, context);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        this.installWithUser(importUser, pack, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installWithUser(String importUser, Package pack, XWikiContext context) throws XWikiException {
        DocumentReference currentUserReference = context.getUserReference();
        if (importUser != null) {
            pack.setBackupPack(false);
            context.setUserReference(new DocumentReference("xwiki", "XWiki", importUser));
        }
        try {
            int code = pack.install(context);
            if (code != 2) {
                throw new XWikiException(3, 0, "Failed to import XAR with code [" + code + "]");
            }
        }
        finally {
            context.setUserReference(currentUserReference);
        }
    }

    public void shutdownHSQLDB(XWikiContext context) throws XWikiException {
        XWikiStoreInterface store = context.getWiki().getStore();
        if (XWikiCacheStore.class.isAssignableFrom(store.getClass())) {
            store = ((XWikiCacheStore)store).getStore();
        }
        if (XWikiHibernateStore.class.isAssignableFrom(store.getClass())) {
            XWikiHibernateStore hibernateStore = (XWikiHibernateStore)store;
            Dialect dialect = Dialect.getDialect((Properties)hibernateStore.getConfiguration().getProperties());
            if (!(dialect instanceof HSQLDialect)) {
                return;
            }
            boolean bTransaction = true;
            try {
                hibernateStore.checkHibernate(context);
                bTransaction = hibernateStore.beginTransaction(false, context);
                Session session = hibernateStore.getSession(context);
                session.connection().createStatement().execute("SHUTDOWN");
                if (bTransaction) {
                    hibernateStore.endTransaction(context, false, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PackageException(1, "Failed to shutdown database", (Throwable)e);
            }
            finally {
                try {
                    if (bTransaction) {
                        hibernateStore.endTransaction(context, false, false);
                    }
                }
                catch (Exception e) {}
            }
        }
    }
}

