/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.doc;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.web.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.model.reference.DocumentReference;

public abstract class AbstractDocumentMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/resources/XWiki/XWikiPreferences")
    protected File sourceDocument;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    private XWikiContext context = this.createXWikiContext();

    protected XWikiContext createXWikiContext() throws MojoExecutionException {
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(((Object)((Object)this)).getClass().getClassLoader());
        Utils.setComponentManager((ComponentManager)ecm);
        ecm.unregisterComponent(ComponentManager.class, "context");
        XWikiContext xcontext = new XWikiContext();
        xcontext.put((Object)ComponentManager.class.getName(), (Object)ecm);
        try {
            ExecutionContextManager ecim = (ExecutionContextManager)ecm.getInstance(ExecutionContextManager.class);
            ExecutionContext econtext = new ExecutionContext();
            xcontext.declareInExecutionContext(econtext);
            ecim.initialize(econtext);
        }
        catch (ComponentLookupException | ExecutionContextException e) {
            throw new MojoExecutionException("Failed to initialize Execution Context.", (Exception)e);
        }
        return xcontext;
    }

    protected XWikiDocument loadFromXML(File file) throws MojoExecutionException {
        XWikiDocument doc = new XWikiDocument(new DocumentReference("xwiki", "XWiki", "WebHome"));
        try {
            FileInputStream fis = new FileInputStream(file);
            doc.fromXML((InputStream)fis);
            FileReader fr = new FileReader(file);
            SAXReader reader = new SAXReader();
            Document domdoc = reader.read((Reader)fr);
            Element root = domdoc.getRootElement();
            List classNodes = root.selectNodes("//xwikidoc/object/class");
            Iterator it = classNodes.iterator();
            while (it.hasNext()) {
                BaseClass bClass = new BaseClass();
                bClass.fromXML((Element)it.next());
                this.context.addBaseClass(bClass);
            }
            fis.close();
            return doc;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading XWikiDocument [" + file + "]", e);
        }
    }

    protected void writeToXML(XWikiDocument doc, File file) throws MojoExecutionException {
        try {
            FileWriter fw = new FileWriter(file);
            this.context.setWiki(new XWiki());
            String xml = doc.toXML(true, false, true, false, this.context);
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing XML for XWikiDocument [" + file + "]", e);
        }
    }

    protected File getSpaceDirectory(File directory, File document) throws MojoExecutionException {
        File spaceDir = new File(directory, document.getParentFile().getName());
        if (!spaceDir.exists()) {
            spaceDir.mkdirs();
        }
        return spaceDir;
    }
}

