/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.properties.converter.Converter;
import org.xwiki.stability.Unstable;
import org.xwiki.tree.EntityTreeFilter;
import org.xwiki.tree.TreeFilter;

@Unstable
public abstract class AbstractEntityTreeFilter
implements TreeFilter,
EntityTreeFilter {
    @Inject
    @Named(value="entityTreeNodeId")
    private Converter<EntityReference> entityTreeNodeIdConverter;

    @Override
    public Set<String> getChildExclusions(String parentNodeId) {
        return this.getChildExclusions(this.resolve(parentNodeId)).stream().map(this::serialize).collect(Collectors.toSet());
    }

    private EntityReference resolve(String nodeId) {
        return (EntityReference)this.entityTreeNodeIdConverter.convert(EntityReference.class, (Object)nodeId);
    }

    private String serialize(EntityReference entityReference) {
        return (String)this.entityTreeNodeIdConverter.convert(String.class, (Object)entityReference);
    }
}

