/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.tree.TreeFilter;
import org.xwiki.tree.TreeNode;

public abstract class AbstractTreeNode
implements TreeNode {
    @Inject
    protected Logger logger;
    @Inject
    @Named(value="context")
    protected Provider<ComponentManager> contextComponentManagerProvider;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public List<String> getChildren(String nodeId, int offset, int limit) {
        return Collections.emptyList();
    }

    @Override
    public int getChildCount(String nodeId) {
        return 0;
    }

    @Override
    public String getParent(String nodeId) {
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    protected String getOrderBy() {
        return (String)this.getProperties().get("orderBy");
    }

    protected Set<String> getExclusions() {
        return this.getProperties().getOrDefault("exclusions", new HashSet());
    }

    protected Set<String> getExclusions(String parentNodeId) {
        HashSet<String> exclusions = new HashSet<String>(this.getExclusions());
        exclusions.addAll(this.getFilters().stream().flatMap(filter -> filter.getChildExclusions(parentNodeId).stream()).collect(Collectors.toSet()));
        return exclusions;
    }

    private List<TreeFilter> getFilters() {
        return this.getProperties().getOrDefault("filters", Collections.emptyList()).stream().map(this::getFilter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private TreeFilter getFilter(Object filter) {
        if (filter instanceof TreeFilter) {
            return (TreeFilter)filter;
        }
        if (filter instanceof String) {
            try {
                return (TreeFilter)((ComponentManager)this.contextComponentManagerProvider.get()).getInstance(TreeFilter.class, (String)filter);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Skipping tree filter [{}]. Root cause is [{}].", filter, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Stacktrace:", (Throwable)e);
            }
        }
        return null;
    }

    protected <E> List<E> subList(List<E> list, int offset, int limit) {
        if (list == null) {
            return Collections.emptyList();
        }
        int start = Math.min(Math.max(offset, 0), list.size());
        int end = Math.max(Math.min(start + limit, list.size()), start);
        return list.subList(start, end);
    }
}

