/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.AbstractAsyncContentBaseObjectWikiComponent;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererDecorator;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.uiextension.UIExtension;

public abstract class AbstractWikiUIExtension
extends AbstractAsyncContentBaseObjectWikiComponent
implements UIExtension {
    protected final JobProgressManager progress;
    protected final ErrorBlockGenerator errorBlockGenerator;
    protected final AsyncContext asyncContext;
    protected final RenderingContext renderingContext;

    public AbstractWikiUIExtension(BaseObject baseObject, Type roleType, String roleHint, ComponentManager componentManager) throws ComponentLookupException, WikiComponentException {
        super(baseObject, roleType, roleHint, componentManager);
        this.progress = (JobProgressManager)componentManager.getInstance(JobProgressManager.class);
        this.errorBlockGenerator = (ErrorBlockGenerator)componentManager.getInstance(ErrorBlockGenerator.class);
        this.asyncContext = (AsyncContext)componentManager.getInstance(AsyncContext.class);
        this.renderingContext = (RenderingContext)componentManager.getInstance(RenderingContext.class);
    }

    protected String getContentPropertyName() {
        return "content";
    }

    public DocumentReference getDocumentReference() {
        return this.objectReference.getDocumentReference();
    }

    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    @Override
    public Block execute() {
        Block result;
        this.progress.startStep((Object)this, "uix.progress.execute", "Execute UIX with id [{}]", new Object[]{this.getId()});
        try {
            BlockAsyncRendererConfiguration executorConfiguration = this.configure();
            result = this.executor.execute(executorConfiguration);
        }
        catch (Exception e) {
            result = new CompositeBlock(this.errorBlockGenerator.generateErrorBlocks(String.format("Failed to execute UIX with id [%s]", this.getId()), (Throwable)e, false));
        }
        finally {
            this.progress.endStep((Object)this);
        }
        return result;
    }

    protected BlockAsyncRendererConfiguration configure() {
        XDOM transformedBlock = this.xdom.clone();
        BlockAsyncRendererConfiguration executorConfiguration = new BlockAsyncRendererConfiguration(Arrays.asList("uix", this.getId()), (Block)transformedBlock);
        executorConfiguration.setTransformationId(this.getRoleHint());
        executorConfiguration.setDefaultSyntax(this.syntax);
        executorConfiguration.setSecureReference(this.getDocumentReference(), this.getAuthorReference());
        executorConfiguration.setTargetSyntax(this.renderingContext.getTargetSyntax());
        if (this instanceof BlockAsyncRendererDecorator) {
            executorConfiguration.setDecorator((BlockAsyncRendererDecorator)this);
        }
        executorConfiguration.setAsyncAllowed(this.asyncAllowed);
        executorConfiguration.setCacheAllowed(this.cacheAllowed);
        if (this.cacheAllowed) {
            executorConfiguration.useComponent(this.getRoleType(), this.getRoleHint());
        }
        executorConfiguration.setContextEntries(this.contextEntries);
        return executorConfiguration;
    }
}

