/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.uiextension.internal.WikiUIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionConstants;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;

@Component
@Singleton
@Named(value="XWiki.UIExtensionClass")
public class WikiUIExtensionComponentBuilder
implements WikiBaseObjectComponentBuilder,
WikiUIExtensionConstants {
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="wiki")
    private ComponentManager wikiComponentManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private AuthorizationManager authorization;

    public EntityReference getClassReference() {
        return UI_EXTENSION_CLASS;
    }

    private void checkRights(XWikiDocument extensionsDoc, WikiComponentScope scope) throws WikiComponentException {
        if (scope == WikiComponentScope.GLOBAL) {
            if (!this.authorization.hasAccess(Right.PROGRAM, extensionsDoc.getAuthorReference(), null)) {
                throw new WikiComponentException("Registering global UI extensions requires programming rights");
            }
        } else if (scope == WikiComponentScope.WIKI && !this.authorization.hasAccess(Right.ADMIN, extensionsDoc.getAuthorReference(), (EntityReference)extensionsDoc.getDocumentReference().getWikiReference())) {
            throw new WikiComponentException("Registering UI extensions at wiki level requires wiki administration rights");
        }
    }

    public List<WikiComponent> buildComponents(BaseObject baseObject) throws WikiComponentException {
        WikiUIExtension extension;
        String extensionPointId = baseObject.getStringValue("extensionPointId");
        if (StringUtils.isEmpty((CharSequence)extensionPointId)) {
            return Collections.emptyList();
        }
        WikiComponentScope scope = WikiComponentScope.fromString((String)baseObject.getStringValue("scope"));
        XWikiDocument ownerDocument = baseObject.getOwnerDocument();
        this.checkRights(ownerDocument, scope);
        String id = baseObject.getStringValue("name");
        String roleHint = (String)this.serializer.serialize(baseObject.getReference(), new Object[0]);
        try {
            extension = new WikiUIExtension(baseObject, roleHint, id, extensionPointId, this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to initialize Panel UI extension [%s]", baseObject.getReference()), (Throwable)e);
        }
        String rawParameters = baseObject.getStringValue("parameters");
        WikiUIExtensionParameters parameters = new WikiUIExtensionParameters(id, rawParameters, this.wikiComponentManager);
        extension.setParameters(parameters);
        extension.setScope(scope);
        return Collections.singletonList(extension);
    }
}

