/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.context.Execution;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityContext;
import org.xwiki.velocity.XWikiVelocityException;

public class WikiUIExtensionParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtensionParameters.class);
    private String id;
    private Properties parameters;
    private Map<String, String> evaluatedParameters;
    private int previousContextId;
    private String previousWiki;
    private VelocityManager velocityManager;
    private ModelContext modelContext;
    private LoggerConfiguration loggerConfiguration;
    private Execution execution;

    public WikiUIExtensionParameters(String id, String rawParameters, ComponentManager cm) throws WikiComponentException {
        this.id = id;
        this.parameters = this.parseParameters(rawParameters);
        try {
            this.execution = (Execution)cm.getInstance(Execution.class);
            this.velocityManager = (VelocityManager)cm.getInstance(VelocityManager.class);
            this.modelContext = (ModelContext)cm.getInstance(ModelContext.class);
            this.loggerConfiguration = (LoggerConfiguration)cm.getInstance(LoggerConfiguration.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException("Failed to get an instance for a component role required by Wiki Components.", (Throwable)e);
        }
    }

    private Properties parseParameters(String rawParameters) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(rawParameters));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to parse UIX parameters [{}]. Cause [{}].", (Object)rawParameters, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return properties;
    }

    public Map<String, String> get() {
        boolean isCacheValid = false;
        int currentContextId = this.execution.getContext().hashCode();
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        if (currentContextId == this.previousContextId && currentWiki.equals(this.previousWiki) && this.evaluatedParameters != null) {
            isCacheValid = true;
        }
        if (!isCacheValid) {
            this.evaluatedParameters = new HashMap<String, String>();
            if (this.parameters.size() > 0) {
                try {
                    VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
                    VelocityContext velocityContext = this.velocityManager.getVelocityContext();
                    for (String propertyKey : this.parameters.stringPropertyNames()) {
                        if (StringUtils.isBlank((CharSequence)propertyKey)) continue;
                        String propertyValue = this.parameters.getProperty(propertyKey);
                        StringWriter writer = new StringWriter();
                        try {
                            String namespace = this.id + ':' + propertyKey;
                            velocityEngine.evaluate((Context)new XWikiVelocityContext((Context)velocityContext, this.loggerConfiguration.isDeprecatedLogEnabled()), (Writer)writer, namespace, propertyValue);
                            this.evaluatedParameters.put(propertyKey, writer.toString());
                        }
                        catch (XWikiVelocityException e) {
                            LOGGER.warn(String.format("Failed to evaluate UI extension data value, key [%s], value [%s]. Reason: [%s]", propertyKey, propertyValue, e.getMessage()));
                        }
                    }
                }
                catch (XWikiVelocityException ex) {
                    LOGGER.warn(String.format("Failed to get velocity engine. Reason: [%s]", ex.getMessage()));
                }
                this.previousContextId = currentContextId;
                this.previousWiki = currentWiki;
            }
        }
        return this.evaluatedParameters;
    }
}

