/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

public class WikiUIExtensionParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiUIExtensionParameters.class);
    private Map<String, String> parameters;
    private Map<String, String> evaluatedParameters;
    private int previousContextId;
    private String previousWiki;
    private VelocityManager velocityManager;
    private ModelContext modelContext;
    private Execution execution;

    public WikiUIExtensionParameters(String rawParameters, ComponentManager cm) throws WikiComponentException {
        this.parameters = this.parseParameters(rawParameters);
        try {
            this.execution = (Execution)cm.getInstance(Execution.class);
            this.velocityManager = (VelocityManager)cm.getInstance(VelocityManager.class);
            this.modelContext = (ModelContext)cm.getInstance(ModelContext.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException("Failed to get an instance for a component role required by Wiki Components.", (Throwable)e);
        }
    }

    private Map<String, String> parseParameters(String rawParameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : rawParameters.split("[\\r\\n]+")) {
            String[] pair = line.split("=", 2);
            if (pair.length != 2 || "".equals(pair[0]) || "".equals(pair[1])) continue;
            result.put(pair[0], pair[1]);
        }
        return result;
    }

    public Map<String, String> get() {
        boolean isCacheValid = false;
        int currentContextId = this.execution.getContext().hashCode();
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        if (currentContextId == this.previousContextId && currentWiki.equals(this.previousWiki) && this.evaluatedParameters != null) {
            isCacheValid = true;
        }
        if (!isCacheValid) {
            this.evaluatedParameters = new HashMap<String, String>();
            if (this.parameters.size() > 0) {
                try {
                    VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
                    VelocityContext velocityContext = this.velocityManager.getVelocityContext();
                    for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                        StringWriter writer = new StringWriter();
                        try {
                            velocityEngine.evaluate((Context)velocityContext, (Writer)writer, "", entry.getValue());
                            this.evaluatedParameters.put(entry.getKey(), writer.toString());
                        }
                        catch (XWikiVelocityException e) {
                            LOGGER.warn(String.format("Failed to evaluate UI extension data value, key [%s], value [%s]. Reason: [%s]", entry.getKey(), entry.getValue(), e.getMessage()));
                        }
                    }
                }
                catch (XWikiVelocityException ex) {
                    LOGGER.warn(String.format("Failed to get velocity engine. Reason: [%s]", ex.getMessage()));
                }
                this.previousContextId = currentContextId;
                this.previousWiki = currentWiki;
            }
        }
        return this.evaluatedParameters;
    }
}

