/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.uiextension.internal.WikiUIExtension;
import org.xwiki.uiextension.internal.WikiUIExtensionConstants;
import org.xwiki.uiextension.internal.WikiUIExtensionParameters;
import org.xwiki.uiextension.internal.WikiUIExtensionRenderer;

@Component
@Singleton
@Named(value="uiextension")
public class WikiUIExtensionComponentBuilder
implements WikiComponentBuilder,
WikiUIExtensionConstants {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="wiki")
    private ComponentManager cm;

    private void checkRights(XWikiDocument extensionsDoc, WikiComponentScope scope) throws WikiComponentException {
        try {
            if (scope == WikiComponentScope.GLOBAL && !this.getXWikiContext().getWiki().getRightService().hasProgrammingRights(extensionsDoc, this.getXWikiContext())) {
                throw new WikiComponentException("Registering global UI extensions requires programming rights");
            }
            if (!this.getXWikiContext().getWiki().getRightService().hasAccessLevel("admin", extensionsDoc.getContentAuthor(), "XWiki.XWikiPreferences", this.getXWikiContext())) {
                throw new WikiComponentException("Registering UI extensions requires admin rights");
            }
        }
        catch (XWikiException e) {
            throw new WikiComponentException("Failed to check rights required to register UI Extension(s)", (Throwable)e);
        }
    }

    private List<BaseObject> getExtensionDefinitions(XWikiDocument extensionsDoc) throws WikiComponentException {
        List extensionDefinitions = extensionsDoc.getXObjects(UI_EXTENSION_CLASS);
        if (extensionDefinitions.size() == 0) {
            throw new WikiComponentException(String.format("No UI extension object could be found in document [%s]", extensionsDoc.getPrefixedFullName()));
        }
        return extensionDefinitions;
    }

    public List<WikiComponent> buildComponents(DocumentReference reference) throws WikiComponentException {
        ArrayList<WikiComponent> extensions = new ArrayList<WikiComponent>();
        XWikiDocument doc = null;
        try {
            doc = this.getXWikiContext().getWiki().getDocument(reference, this.getXWikiContext());
        }
        catch (XWikiException e) {
            throw new WikiComponentException(String.format("Failed to create UI Extension(s) document [%s]", reference), (Throwable)e);
        }
        for (BaseObject extensionDefinition : this.getExtensionDefinitions(doc)) {
            if (extensionDefinition == null) continue;
            String id = extensionDefinition.getStringValue("name");
            String extensionPointId = extensionDefinition.getStringValue("extensionPointId");
            String content = extensionDefinition.getStringValue("content");
            String rawParameters = extensionDefinition.getStringValue("parameters");
            WikiComponentScope scope = WikiComponentScope.fromString((String)extensionDefinition.getStringValue("scope"));
            this.checkRights(doc, scope);
            String roleHint = (String)this.serializer.serialize(extensionDefinition.getReference(), new Object[0]);
            WikiUIExtension extension = new WikiUIExtension(roleHint, id, extensionPointId, (ObjectReference)extensionDefinition.getReference(), doc.getAuthorReference());
            WikiUIExtensionParameters parameters = new WikiUIExtensionParameters(rawParameters, this.cm);
            extension.setParameters(parameters);
            WikiUIExtensionRenderer renderer = new WikiUIExtensionRenderer(roleHint, content, doc.getDocumentReference(), this.cm);
            extension.setRenderer(renderer);
            extension.setScope(scope);
            extensions.add(extension);
        }
        return extensions;
    }

    public List<DocumentReference> getDocumentReferences() {
        ArrayList<DocumentReference> results = new ArrayList<DocumentReference>();
        String query = ", BaseObject as obj, StringProperty as epId where obj.className=? and obj.name=doc.fullName and epId.id.id=obj.id and epId.id.name=? and  (epId.value <> '' or (epId.value is not null and '' is null))";
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.compactWikiSerializer.serialize(UI_EXTENSION_CLASS, new Object[0]));
        parameters.add("extensionPointId");
        try {
            results.addAll(this.getXWikiContext().getWiki().getStore().searchDocumentReferences(query, parameters, this.getXWikiContext()));
        }
        catch (XWikiException e) {
            this.logger.warn("Search for UI extensions failed: [{}]", (Object)e.getMessage());
        }
        return results;
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

