/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.uiextension.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.uiextension.UIExtensionManager;

public class DefaultUIExtensionManager
implements UIExtensionManager {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    @Override
    public List<UIExtension> get(String extensionPointId) {
        ArrayList<UIExtension> extensions = new ArrayList<UIExtension>();
        try {
            List allExtensions = ((ComponentManager)this.contextComponentManagerProvider.get()).getInstanceList(UIExtension.class);
            for (UIExtension extension : allExtensions) {
                if (!extension.getExtensionPointId().equals(extensionPointId)) continue;
                extensions.add(extension);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup UIExtension instances, error: [{}]", (Throwable)e);
        }
        return extensions;
    }
}

